/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context.internal.sur.handlers;

import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.OptionalValueSupplier;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.context.internal.ExtractedInputFlag;
import studio.mevera.imperat.context.internal.sur.HandleResult;
import studio.mevera.imperat.context.internal.sur.handlers.ParameterHandler;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.util.ImperatDebugger;

public final class OptionalParameterHandler<S extends Source>
implements ParameterHandler<S> {
    @Override
    @NotNull
    public HandleResult handle(ExecutionContext<S> context, CommandInputStream<S> stream) {
        CommandParameter<S> currentParameter = stream.currentParameterIfPresent();
        String currentRaw = stream.currentRawIfPresent();
        if (currentParameter == null || currentRaw == null || !currentParameter.isOptional()) {
            return HandleResult.NEXT_HANDLER;
        }
        try {
            if (currentParameter.isFlag()) {
                ExtractedInputFlag value = (ExtractedInputFlag)currentParameter.type().resolve(context, stream, stream.readInput());
                context.resolveFlag(value);
                if (!currentParameter.asFlagParameter().isSwitch()) {
                    stream.skipRaw();
                }
                stream.skip();
            } else {
                this.resolveOptional(currentRaw, currentParameter, context, stream);
            }
            return HandleResult.NEXT_ITERATION;
        }
        catch (ImperatException e) {
            return HandleResult.failure(e);
        }
    }

    private void resolveOptional(String currentRaw, CommandParameter<S> currentParameter, ExecutionContext<S> context, CommandInputStream<S> stream) throws ImperatException {
        ImperatDebugger.debug("Handling " + currentParameter.format(), new Object[0]);
        boolean isObligatedToSkip = this.calculateObligationToSkip(stream);
        if (isObligatedToSkip) {
            ImperatDebugger.debug("MUST SKIP", new Object[0]);
            Object defaultValue = this.getDefaultValue(context, stream, currentParameter);
            context.resolveArgument(stream, defaultValue);
            stream.skipParameter();
            return;
        }
        if (!context.imperatConfig().handleExecutionMiddleOptionalSkipping()) {
            ImperatDebugger.debug("MUST CONSUME INPUT, OPTION SKIPPING IS DISABLED", new Object[0]);
            this.consumeInput(currentRaw, currentParameter, context, stream);
            return;
        }
        if (currentParameter.type().matchesInput(stream.currentRawPosition(), context, currentParameter)) {
            ImperatDebugger.debug("IT MATCHES TYPE, CONSUMING RIGHT AWAY", new Object[0]);
            this.consumeInput(currentRaw, currentParameter, context, stream);
            return;
        }
        CommandParameter<S> bestMatch = this.findBestDownstreamMatch(stream, context);
        if (bestMatch != null && !this.hasRequiredParametersBetween(stream, bestMatch)) {
            ImperatDebugger.debug("Found better match down stream : '" + bestMatch.format() + "'", new Object[0]);
            Object defaultValue = this.getDefaultValue(context, stream, currentParameter);
            context.resolveArgument(stream, defaultValue);
            stream.skipParameter();
            return;
        }
        try {
            this.consumeInput(currentRaw, currentParameter, context, stream);
            ImperatDebugger.debug("CONSUMING....", new Object[0]);
        }
        catch (ImperatException e) {
            ImperatDebugger.debug("FAILED TO CONSUME, SETTING DEFAULT", new Object[0]);
            Object defaultValue = this.getDefaultValue(context, stream, currentParameter);
            context.resolveArgument(stream, defaultValue);
            stream.skipParameter();
        }
    }

    private boolean calculateObligationToSkip(CommandInputStream<S> stream) {
        int currentParamPos = stream.currentParameterPosition();
        int currentRawPos = stream.currentRawPosition();
        int remainingRequired = 0;
        for (int i = currentParamPos + 1; i < stream.parametersLength(); ++i) {
            CommandParameter<S> param = stream.getParametersList().get(i);
            if (!param.isRequired()) continue;
            ++remainingRequired;
        }
        int remainingRawInputs = stream.rawsLength() - currentRawPos - 1;
        return remainingRequired > remainingRawInputs;
    }

    private CommandParameter<S> findBestDownstreamMatch(CommandInputStream<S> stream, ExecutionContext<S> ctx) {
        int currentParamPos = stream.currentParameterPosition();
        int currRawPos = stream.currentRawPosition();
        for (int i = currentParamPos + 1; i < stream.parametersLength(); ++i) {
            CommandParameter<S> param = stream.getParametersList().get(i);
            if (!param.isOptional() || param.isFlag() || !param.type().matchesInput(currRawPos, ctx, param)) continue;
            return param;
        }
        return null;
    }

    private boolean hasRequiredParametersBetween(CommandInputStream<S> stream, CommandParameter<S> targetParam) {
        int currentParamPos = stream.currentParameterPosition();
        int targetParamPos = targetParam.position();
        for (int i = currentParamPos + 1; i < targetParamPos; ++i) {
            CommandParameter<S> param = stream.getParametersList().get(i);
            if (!param.isRequired()) continue;
            return true;
        }
        return false;
    }

    private void consumeInput(String currentRaw, CommandParameter<S> currentParameter, ExecutionContext<S> context, CommandInputStream<S> stream) throws ImperatException {
        Object value = currentParameter.type().resolve(context, stream, currentRaw);
        context.resolveArgument(stream, value);
        stream.skip();
    }

    private <T> T getDefaultValue(ExecutionContext<S> context, CommandInputStream<S> stream, CommandParameter<S> parameter) throws ImperatException {
        OptionalValueSupplier optionalSupplier = parameter.getDefaultValueSupplier();
        if (optionalSupplier.isEmpty()) {
            return null;
        }
        String value = optionalSupplier.supply(context, parameter);
        if (value != null) {
            return (T)parameter.type().resolve(context, stream, value);
        }
        return null;
    }
}

