/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context.internal.sur.handlers;

import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.context.internal.ExtractedInputFlag;
import studio.mevera.imperat.context.internal.sur.HandleResult;
import studio.mevera.imperat.context.internal.sur.handlers.ParameterHandler;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.InvalidSyntaxException;

public final class RequiredParameterHandler<S extends Source>
implements ParameterHandler<S> {
    @Override
    @NotNull
    public HandleResult handle(ExecutionContext<S> context, CommandInputStream<S> stream) {
        CommandParameter<S> currentParameter = stream.currentParameterIfPresent();
        String currentRaw = stream.currentRawIfPresent();
        if (currentParameter == null) {
            return HandleResult.TERMINATE;
        }
        if (!currentParameter.isRequired()) {
            return HandleResult.NEXT_HANDLER;
        }
        if (currentRaw == null) {
            return HandleResult.failure(new InvalidSyntaxException(context.getPathwaySearch(), context));
        }
        try {
            Object value = currentParameter.type().resolve(context, stream, stream.readInput());
            if (value instanceof ExtractedInputFlag) {
                ExtractedInputFlag extractedInputFlag = (ExtractedInputFlag)value;
                context.resolveFlag(extractedInputFlag);
                stream.skip();
            } else {
                context.resolveArgument(context.getLastUsedCommand(), currentRaw, stream.currentParameterPosition(), currentParameter, value);
                stream.skip();
            }
            return HandleResult.NEXT_ITERATION;
        }
        catch (ImperatException e) {
            return HandleResult.failure(e);
        }
    }
}

