/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context.internal.sur.handlers;

import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.context.internal.sur.HandleResult;
import studio.mevera.imperat.context.internal.sur.handlers.ParameterHandler;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.parse.UnknownSubCommandException;

public final class SubCommandHandler<S extends Source>
implements ParameterHandler<S> {
    @Override
    @NotNull
    public HandleResult handle(ExecutionContext<S> context, CommandInputStream<S> stream) {
        CommandParameter<S> currentParameter = stream.currentParameterIfPresent();
        String currentRaw = stream.currentRawIfPresent();
        if (currentParameter == null) {
            return HandleResult.TERMINATE;
        }
        if (currentRaw == null || !currentParameter.isCommand()) {
            return HandleResult.NEXT_HANDLER;
        }
        try {
            Command parameterSubCmd = (Command)currentParameter;
            if (parameterSubCmd.hasName(currentRaw)) {
                stream.skip();
                return HandleResult.NEXT_ITERATION;
            }
            return HandleResult.failure(new UnknownSubCommandException(currentRaw, context));
        }
        catch (Exception e) {
            return HandleResult.failure(new ImperatException("Error processing command parameter", e, context));
        }
    }
}

