/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.exception;

import java.time.Duration;
import java.time.Instant;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.exception.ImperatException;

public final class CooldownException
extends ImperatException {
    private final Duration cooldownDuration;
    private final Duration remainingDuration;
    private final Instant lastTimeExecuted;

    public CooldownException(Duration cooldownDuration, Instant lastTimeExecuted, Context<?> ctx) {
        super(ctx);
        this.cooldownDuration = cooldownDuration;
        this.lastTimeExecuted = lastTimeExecuted;
        Duration elapsed = Duration.between(lastTimeExecuted, Instant.now());
        Duration remaining = cooldownDuration.minus(elapsed);
        this.remainingDuration = remaining.isNegative() ? Duration.ZERO : remaining;
    }

    public Duration getCooldownDuration() {
        return this.cooldownDuration;
    }

    public Instant getLastTimeExecuted() {
        return this.lastTimeExecuted;
    }

    public Duration getRemainingDuration() {
        return this.remainingDuration;
    }
}

