/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.exception;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.tree.CommandPathSearch;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.ImperatException;

public final class PermissionDeniedException
extends ImperatException {
    private final String lackingPermission;
    private final CommandUsage<?> usage;
    @Nullable
    private final CommandParameter<?> targetParameter;

    public <S extends Source> PermissionDeniedException(@NotNull CommandUsage<S> usage, @NotNull String lackingPermission, @Nullable CommandParameter<S> targetParameter, Context<S> context) {
        super("Lacking permission '" + lackingPermission + "'", context);
        this.usage = usage;
        this.lackingPermission = lackingPermission;
        this.targetParameter = targetParameter;
    }

    public <S extends Source> PermissionDeniedException(CommandPathSearch<S> pathSearch, Context<S> context) {
        this(pathSearch.getFoundUsage() != null ? pathSearch.getFoundUsage() : ((Command)pathSearch.getLastCommandNode().getData()).getDefaultUsage(), Objects.requireNonNull(pathSearch.getLastNode()).getPermission(), (CommandParameter<S>)pathSearch.getLastNode().getData(), context);
    }

    @NotNull
    public String getLackingPermission() {
        return this.lackingPermission;
    }

    @NotNull
    public <S extends Source> CommandUsage<S> getUsage() {
        return this.usage;
    }

    @Nullable
    public <S extends Source> CommandParameter<S> getInAccessibleParameter() {
        return this.targetParameter;
    }
}

