/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.resolvers;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.util.Pair;

@ApiStatus.AvailableSince(value="1.0.0")
public interface PermissionChecker<S extends Source> {
    public boolean hasPermission(@NotNull S var1, @Nullable String var2);

    default public boolean hasPermission(@NotNull S source, @NotNull CommandParameter<S> parameter) {
        return this.hasPermission(source, parameter.getSinglePermission());
    }

    default public Pair<String, Boolean> hasUsagePermission(S source, @Nullable CommandUsage<S> usage) {
        if (usage == null) {
            return new Pair<Object, Boolean>(null, true);
        }
        for (String perm : usage.getPermissions()) {
            if (this.hasPermission(source, perm)) continue;
            return new Pair<String, Boolean>(perm, false);
        }
        return new Pair<Object, Boolean>(null, true);
    }
}

