/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.resolvers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.SuggestionContext;
import studio.mevera.imperat.resolvers.StaticSuggestionResolver;

@ApiStatus.AvailableSince(value="1.0.0")
public interface SuggestionResolver<S extends Source> {
    public static <S extends Source> SuggestionResolver<S> staticSuggestions(List<String> results) {
        return new StaticSuggestionResolver(results);
    }

    public static <S extends Source> SuggestionResolver<S> staticSuggestions(String ... results) {
        return SuggestionResolver.staticSuggestions(Arrays.asList(results));
    }

    public static <S extends Source> SuggestionResolver<S> forCommand(Command<S> command) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(command.name());
        list.addAll(command.aliases());
        return SuggestionResolver.staticSuggestions(list);
    }

    public List<String> autoComplete(SuggestionContext<S> var1, CommandParameter<S> var2);

    default public CompletableFuture<List<String>> asyncAutoComplete(SuggestionContext<S> context, CommandParameter<S> parameter) {
        return CompletableFuture.supplyAsync(() -> this.autoComplete(context, parameter));
    }
}

