/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public abstract class TypeCapturer {
    protected Type extractType(int index) {
        Type genericSuperClass = this.getClass().getGenericSuperclass();
        if (genericSuperClass instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)genericSuperClass;
            Type[] args = parameterized.getActualTypeArguments();
            if (index < 0 || index >= args.length) {
                throw new IndexOutOfBoundsException("No type argument at index " + index);
            }
            return this.resolveType(args[index]);
        }
        throw new IllegalStateException("Superclass is not parameterized: " + String.valueOf(genericSuperClass));
    }

    protected Type extractType(Class<?> targetSuperclass, int index) {
        Class current = this.getClass();
        while (current != null && current != Object.class) {
            Class raw;
            Type genericSuper = current.getGenericSuperclass();
            if (genericSuper instanceof ParameterizedType) {
                ParameterizedType parameterized = (ParameterizedType)genericSuper;
                Class raw2 = (Class)parameterized.getRawType();
                if (raw2.equals(targetSuperclass)) {
                    Type[] args = parameterized.getActualTypeArguments();
                    if (index < 0 || index >= args.length) {
                        throw new IndexOutOfBoundsException("No type argument at index " + index);
                    }
                    return this.resolveType(args[index]);
                }
                current = raw2;
                continue;
            }
            if (!(genericSuper instanceof Class)) break;
            current = raw = (Class)genericSuper;
        }
        throw new IllegalStateException("Superclass " + targetSuperclass.getName() + " not found in hierarchy of " + this.getClass().getName());
    }

    private Type resolveType(Type type) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] args = pt.getActualTypeArguments();
            Type[] resolvedArgs = new Type[args.length];
            for (int i = 0; i < args.length; ++i) {
                resolvedArgs[i] = this.resolveType(args[i]);
            }
            return new ResolvedParameterizedType((Class)pt.getRawType(), resolvedArgs, pt.getOwnerType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            Type comp = this.resolveType(gat.getGenericComponentType());
            if (comp instanceof Class) {
                Class cls = (Class)comp;
                return Array.newInstance(cls, 0).getClass();
            }
            return new ResolvedGenericArrayType(comp);
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return this.resolveTypeVariable(tv, this.getClass(), new HashMap());
        }
        return type;
    }

    private Type resolveTypeVariable(TypeVariable<?> target, Class<?> startClass, Map<TypeVariable<?>, Type> typeMap) {
        Class current = startClass;
        while (current != null && current != Object.class) {
            Type superclass = current.getGenericSuperclass();
            if (!(superclass instanceof ParameterizedType)) {
                current = current.getSuperclass();
                continue;
            }
            ParameterizedType parameterized = (ParameterizedType)superclass;
            Class raw = (Class)parameterized.getRawType();
            Type[] actualArgs = parameterized.getActualTypeArguments();
            TypeVariable<Class<T>>[] declaredVars = raw.getTypeParameters();
            for (int i = 0; i < declaredVars.length; ++i) {
                TypeVariable tv;
                Type actual = actualArgs[i];
                if (actual instanceof TypeVariable && typeMap.containsKey(tv = (TypeVariable)actual)) {
                    typeMap.put(declaredVars[i], typeMap.get(tv));
                    continue;
                }
                typeMap.put(declaredVars[i], actual);
            }
            current = raw;
        }
        TypeVariable<?> resolved = typeMap.get(target);
        if (resolved instanceof TypeVariable) {
            TypeVariable nested = resolved;
            return this.resolveTypeVariable(nested, startClass, typeMap);
        }
        return resolved != null ? resolved : target;
    }

    private Type substituteTypeVariables(Type type, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            Type mapped = typeVarAssigns.get(tv);
            if (mapped != null && !mapped.equals(tv)) {
                return this.substituteTypeVariables(mapped, typeVarAssigns);
            }
            return tv;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] args = pt.getActualTypeArguments();
            Type[] resolved = new Type[args.length];
            for (int i = 0; i < args.length; ++i) {
                resolved[i] = this.substituteTypeVariables(args[i], typeVarAssigns);
            }
            return new ResolvedParameterizedType((Class)pt.getRawType(), resolved, pt.getOwnerType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            Type comp = this.substituteTypeVariables(gat.getGenericComponentType(), typeVarAssigns);
            if (comp instanceof Class) {
                Class cls = (Class)comp;
                return Array.newInstance(cls, 0).getClass();
            }
            return new ResolvedGenericArrayType(comp);
        }
        return type;
    }

    private static class ResolvedParameterizedType
    implements ParameterizedType {
        private final Class<?> raw;
        private final Type[] args;
        private final Type owner;

        ResolvedParameterizedType(Class<?> raw, Type[] args, Type owner) {
            this.raw = raw;
            this.args = args;
            this.owner = owner;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.args;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return this.owner;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.raw.getTypeName());
            if (this.args.length > 0) {
                sb.append("<");
                for (int i = 0; i < this.args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.args[i].getTypeName());
                }
                sb.append(">");
            }
            return sb.toString();
        }
    }

    private static class ResolvedGenericArrayType
    implements GenericArrayType {
        private final Type component;

        ResolvedGenericArrayType(Type component) {
            this.component = component;
        }

        @Override
        public Type getGenericComponentType() {
            return this.component;
        }

        public String toString() {
            return this.component.getTypeName() + "[]";
        }
    }
}

