/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.util.TypeUtility;
import studio.mevera.imperat.util.TypeVisitor;

public abstract class TypeWrap<T> {
    private final Type type;
    private final Class<?> rawType;

    protected TypeWrap() {
        this.type = this.extractType();
        this.rawType = this.extractRawType(this.type);
    }

    private TypeWrap(Type type) {
        this.type = type;
        this.rawType = this.extractRawType(type);
    }

    public static TypeWrap<?> of(Type type) {
        return new TypeWrap<Object>(type){};
    }

    public static <T> TypeWrap<T> of(Class<T> type) {
        return new TypeWrap<T>(type){};
    }

    private static Bounds any(Type[] bounds) {
        return new Bounds(bounds, true);
    }

    public static <S extends Source> TypeWrap<?> ofParameterized(Type rawClass, List<ParameterType<S, ?>> genericParamTypes) {
        if (!(rawClass instanceof Class)) {
            throw new IllegalArgumentException("Raw class must be a class.");
        }
        final Class clazz = (Class)rawClass;
        if (genericParamTypes.isEmpty()) {
            return TypeWrap.of(rawClass);
        }
        final Type[] typeArgs = new Type[genericParamTypes.size()];
        for (int i = 0; i < genericParamTypes.size(); ++i) {
            typeArgs[i] = genericParamTypes.get(i).type();
        }
        ParameterizedType parameterizedType = new ParameterizedType(){

            @Override
            public Type @NotNull [] getActualTypeArguments() {
                return typeArgs;
            }

            @Override
            public Type getRawType() {
                return clazz;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
        return TypeWrap.of(parameterizedType);
    }

    public static TypeWrap<?> ofArray(Type type) {
        Class<?> arrayType = Array.newInstance(TypeWrap.of(type).getRawType(), 0).getClass();
        return TypeWrap.of(arrayType);
    }

    private Type extractType() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)superclass;
            return parameterizedType.getActualTypeArguments()[0];
        }
        if (superclass instanceof Class) {
            return Object.class;
        }
        throw new IllegalArgumentException("TypeWrap must be created with a parameterized valueType.");
    }

    private Class<?> extractRawType(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return Array.newInstance(this.extractRawType(genericArrayType.getGenericComponentType()), 0).getClass();
        }
        return null;
    }

    public Type[] getParameterizedTypes() {
        if (this.type == null) {
            return null;
        }
        Type type = this.type;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getActualTypeArguments();
        }
        return null;
    }

    public Type getType() {
        return this.type;
    }

    public Class<? super T> getRawType() {
        return this.rawType;
    }

    private Set<Class<? super T>> getRawTypes() {
        final HashSet<Class<? super T>> builder = new HashSet<Class<? super T>>();
        new TypeVisitor(){

            @Override
            void visitTypeVariable(TypeVariable<?> t) {
                this.visit(t.getBounds());
            }

            @Override
            void visitWildcardType(WildcardType t) {
                this.visit(t.getUpperBounds());
            }

            @Override
            void visitParameterizedType(ParameterizedType t) {
                builder.add((Class)t.getRawType());
            }

            @Override
            void visitClass(Class<?> t) {
                builder.add(t);
            }

            @Override
            void visitGenericArrayType(GenericArrayType t) {
                builder.add(TypeUtility.getArrayClass(TypeWrap.of(t.getGenericComponentType()).getRawType()));
            }
        }.visit(this.type);
        return builder;
    }

    public final boolean isPrimitive() {
        return TypeUtility.isPrimitive(this.type);
    }

    public final boolean isWrapped() {
        return TypeUtility.isBoxed(this.type);
    }

    public TypeWrap<?> wrap() {
        if (this.isPrimitive()) {
            return TypeWrap.of(TypeUtility.primitiveToBoxed(this.type));
        }
        return this;
    }

    public TypeWrap<?> unwrap() {
        if (this.isWrapped()) {
            return TypeWrap.of(TypeUtility.boxedToPrimative(this.type));
        }
        return this;
    }

    public final boolean isArray() {
        return this.getComponentType() != null;
    }

    public TypeWrap<?> getComponentType() {
        Type componentType = TypeUtility.getComponentType(this.type);
        if (componentType == null) {
            return null;
        }
        return TypeWrap.of(componentType);
    }

    public final boolean isSupertypeOf(TypeWrap<?> type) {
        return type.isSubtypeOf(this.getType());
    }

    public final boolean isSupertypeOf(Type type) {
        return TypeWrap.of(type).isSubtypeOf(this.getType());
    }

    public final boolean isSubtypeOf(TypeWrap<?> type) {
        return this.isSubtypeOf(type.getType());
    }

    public final boolean isSubtypeOf(Type supertype) {
        if (supertype == null) {
            return false;
        }
        if (supertype instanceof WildcardType) {
            return TypeWrap.any(((WildcardType)supertype).getLowerBounds()).isSupertypeOf(this.type);
        }
        if (this.type instanceof WildcardType) {
            return TypeWrap.any(((WildcardType)this.type).getUpperBounds()).isSubtypeOf(supertype);
        }
        if (this.type instanceof TypeVariable) {
            return this.type.equals(supertype) || TypeWrap.any(((TypeVariable)this.type).getBounds()).isSubtypeOf(supertype);
        }
        if (this.type instanceof GenericArrayType) {
            return TypeWrap.of(supertype).isSupertypeOfArray((GenericArrayType)this.type);
        }
        if (supertype instanceof Class) {
            Class clazz = (Class)supertype;
            return this.someRawTypeIsSubclassOf(clazz);
        }
        if (supertype instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)supertype;
            return this.isSubtypeOfParameterizedType(parameterizedType);
        }
        if (supertype instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)supertype;
            return this.isSubtypeOfArrayType(genericArrayType);
        }
        return false;
    }

    private boolean isSupertypeOfArray(GenericArrayType subtype) {
        Type type = this.type;
        if (type instanceof Class) {
            Class thisClass = (Class)type;
            if (!thisClass.isArray()) {
                return thisClass.isAssignableFrom(Object[].class);
            }
            return TypeWrap.of(subtype.getGenericComponentType()).isSubtypeOf(thisClass.getComponentType());
        }
        if (this.type instanceof GenericArrayType) {
            return TypeWrap.of(subtype.getGenericComponentType()).isSubtypeOf(((GenericArrayType)this.type).getGenericComponentType());
        }
        return false;
    }

    private boolean someRawTypeIsSubclassOf(Class<?> superclass) {
        for (Class<T> rawType : this.getRawTypes()) {
            if (!superclass.isAssignableFrom(rawType)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubtypeOfParameterizedType(ParameterizedType supertype) {
        Type type = this.type;
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType subType = (ParameterizedType)type;
        Class superRawType = (Class)supertype.getRawType();
        Class subRawType = (Class)subType.getRawType();
        if (!superRawType.isAssignableFrom(subRawType)) {
            return false;
        }
        Type[] superTypeArgs = supertype.getActualTypeArguments();
        Type[] subTypeArgs = subType.getActualTypeArguments();
        for (int i = 0; i < superTypeArgs.length; ++i) {
            if (this.isTypeArgCompatible(subTypeArgs[i], superTypeArgs[i])) continue;
            return false;
        }
        return this.isCompatibleOwnerType(supertype, subType);
    }

    private boolean isSubtypeOfArrayType(GenericArrayType supertype) {
        Type type = this.type;
        if (type instanceof Class) {
            Class fromClass = (Class)type;
            if (!fromClass.isArray()) {
                return false;
            }
            return TypeWrap.of(fromClass.getComponentType()).isSubtypeOf(supertype.getGenericComponentType());
        }
        type = this.type;
        if (type instanceof GenericArrayType) {
            GenericArrayType fromArrayType = (GenericArrayType)type;
            return TypeWrap.of(fromArrayType.getGenericComponentType()).isSubtypeOf(supertype.getGenericComponentType());
        }
        return false;
    }

    private boolean isTypeArgCompatible(Type subArg, Type superArg) {
        if (superArg instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)superArg;
            return this.isWithinWildcardBounds(subArg, wildcard);
        }
        if (superArg instanceof TypeVariable) {
            TypeVariable var = (TypeVariable)superArg;
            return this.isWithinTypeVarBounds(subArg, var);
        }
        return TypeWrap.of(subArg).isSubtypeOf(superArg);
    }

    private boolean isWithinWildcardBounds(Type type, WildcardType wildcard) {
        return this.isWithinBounds(type, wildcard.getLowerBounds(), wildcard.getUpperBounds());
    }

    private boolean isWithinTypeVarBounds(Type type, TypeVariable<?> typeVar) {
        return this.isWithinBounds(type, new Type[0], typeVar.getBounds());
    }

    private boolean isCompatibleOwnerType(ParameterizedType supertype, ParameterizedType subtype) {
        Type superOwner = supertype.getOwnerType();
        Type subOwner = subtype.getOwnerType();
        return superOwner == null || subOwner != null && TypeWrap.of(subOwner).isSubtypeOf(superOwner);
    }

    private boolean isWithinBounds(Type type, Type[] lowerBounds, Type[] upperBounds) {
        for (Type lowerBound : lowerBounds) {
            if (TypeWrap.of(lowerBound).isSubtypeOf(type)) continue;
            return false;
        }
        for (Type upperBound : upperBounds) {
            if (TypeWrap.of(type).isSubtypeOf(upperBound)) continue;
            return false;
        }
        return true;
    }

    private record Bounds(Type[] bounds, boolean target) {
        boolean isSubtypeOf(Type supertype) {
            for (Type bound : this.bounds) {
                if (TypeWrap.of(bound).isSubtypeOf(supertype) != this.target) continue;
                return this.target;
            }
            return !this.target;
        }

        boolean isSupertypeOf(Type subtype) {
            TypeWrap<?> type = TypeWrap.of(subtype);
            for (Type bound : this.bounds) {
                if (type.isSubtypeOf(bound) != this.target) continue;
                return this.target;
            }
            return !this.target;
        }
    }
}

