/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.util.reflection.FieldAccessor;

public final class Reflections {
    public static <T> FieldAccessor<T> getField(Class<?> target, String name, Class<T> fieldType) {
        return Reflections.getField(target, name, fieldType, 0);
    }

    public static <T> FieldAccessor<T> getField(String className, String name, Class<T> fieldType) {
        return Reflections.getField(Reflections.getClass(className), name, fieldType, 0);
    }

    public static <T> FieldAccessor<T> getField(Class<?> target, Class<T> fieldType) {
        return Reflections.getField(target, null, fieldType, 0);
    }

    public static <T> FieldAccessor<T> getField(Class<?> target, Class<T> fieldType, int index) {
        return Reflections.getField(target, null, fieldType, index);
    }

    public static <T> FieldAccessor<T> getField(String className, Class<T> fieldType, int index) {
        return Reflections.getField(Reflections.getClass(className), fieldType, index);
    }

    private static <T> FieldAccessor<T> getField(Class<?> target, String name, Class<T> fieldType, int index) {
        if (target == null) {
            throw new IllegalArgumentException("Target class is null");
        }
        for (final Field field : target.getDeclaredFields()) {
            if (name != null && !field.getName().equals(name) || !fieldType.isAssignableFrom(field.getType()) || index-- > 0) continue;
            field.setAccessible(true);
            return new FieldAccessor<T>(){

                @Override
                public T get(Object target) {
                    try {
                        return field.get(target);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Cannot access reflection.", e);
                    }
                }

                @Override
                public void set(Object target, Object value) {
                    try {
                        field.set(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Cannot access reflection.", e);
                    }
                }

                @Override
                public boolean hasField(Object target) {
                    return field.getDeclaringClass().isAssignableFrom(target.getClass());
                }
            };
        }
        if (target.getSuperclass() != null) {
            return Reflections.getField(target.getSuperclass(), name, fieldType, index);
        }
        throw new IllegalArgumentException("Cannot find field with valueType " + String.valueOf(fieldType));
    }

    public static boolean findClass(Supplier<Class<?>> classSupplier) {
        try {
            return classSupplier.get() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean findClass(String ... paths) {
        for (String path : paths) {
            if (Reflections.getClass(path) == null) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getClass(@NotNull String path) {
        try {
            return Class.forName(path);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Constructor<?> getConstructor(@NotNull Class<?> clazz, Class<?> ... classes) {
        try {
            return clazz.getDeclaredConstructor(classes);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

