/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.verification;

import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.verification.UsageVerifier;

@ApiStatus.Internal
class SimpleVerifier<S extends Source>
implements UsageVerifier<S> {
    SimpleVerifier() {
    }

    @Override
    public boolean verify(CommandUsage<S> usage) {
        if (usage.getParameters().isEmpty()) {
            return true;
        }
        int greedyCount = 0;
        for (int i = 0; i < usage.getMaxLength(); ++i) {
            CommandParameter<S> param = usage.getParameters().get(i);
            if (!param.isGreedy()) continue;
            ++greedyCount;
        }
        if (greedyCount > 1) {
            return false;
        }
        CommandParameter<S> greedyParam = usage.getParameter(CommandParameter::isGreedy);
        if (greedyParam == null) {
            return true;
        }
        return greedyParam.position() == usage.getMaxLength() - 1;
    }

    @Override
    public boolean areAmbiguous(CommandUsage<S> firstUsage, CommandUsage<S> secondUsage) {
        boolean hasSubCommands;
        boolean sameLength = firstUsage.getMinLength() == secondUsage.getMinLength();
        boolean bl = hasSubCommands = firstUsage.hasParamType(Command.class) && secondUsage.hasParamType(Command.class);
        if (sameLength && hasSubCommands) {
            ArrayList<CommandParameter<S>> parameterList1 = new ArrayList<CommandParameter<S>>(firstUsage.getParameters());
            parameterList1.removeIf(param -> !param.isCommand());
            ArrayList<CommandParameter<S>> parameterList2 = new ArrayList<CommandParameter<S>>(secondUsage.getParameters());
            parameterList2.removeIf(param -> !param.isCommand());
            return parameterList1.equals(parameterList2);
        }
        if (sameLength) {
            int capacity = firstUsage.getMinLength();
            for (int i = 0; i < capacity; ++i) {
                CommandParameter<S> firstUsageParameter = firstUsage.getParameter(i);
                CommandParameter<S> secondUsageParameter = secondUsage.getParameter(i);
                if (firstUsageParameter == null || secondUsageParameter == null) break;
                if ((!firstUsageParameter.isCommand() || secondUsageParameter.isCommand()) && (firstUsageParameter.isCommand() || !secondUsageParameter.isCommand())) continue;
                return false;
            }
        }
        return sameLength;
    }
}

