/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.verification;

import org.jetbrains.annotations.ApiStatus;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.util.TypeUtility;
import studio.mevera.imperat.verification.SimpleVerifier;

@ApiStatus.Internal
final class TypeTolerantVerifier<S extends Source>
extends SimpleVerifier<S> {
    TypeTolerantVerifier() {
    }

    @Override
    public boolean verify(CommandUsage<S> usage) {
        return super.verify(usage);
    }

    @Override
    public boolean areAmbiguous(CommandUsage<S> firstUsage, CommandUsage<S> secondUsage) {
        int sizeDiff = firstUsage.getMinLength() - secondUsage.getMinLength();
        if (sizeDiff != 0) {
            return false;
        }
        int capacity = firstUsage.getMinLength();
        boolean noDiff = true;
        for (int depth = 0; depth < capacity; ++depth) {
            CommandParameter<S> param1 = firstUsage.getParameter(depth);
            CommandParameter<S> param2 = secondUsage.getParameter(depth);
            assert (param1 != null && param2 != null);
            if (this.areSimilarParameters(param1, param2)) continue;
            noDiff = false;
            break;
        }
        return noDiff;
    }

    private boolean areSimilarParameters(CommandParameter<S> param1, CommandParameter<S> param2) {
        if (!param1.isCommand() && !param2.isCommand()) {
            return TypeUtility.matches(param1.valueType(), param2.valueType());
        }
        if (param1.isCommand() && param2.isCommand()) {
            return param1.equals(param2);
        }
        return false;
    }
}

