/*
 * Decompiled with CFR 0.152.
 */
package studio.wetrack.accountService;

import org.springframework.util.StringUtils;
import studio.wetrack.accountService.AccountException;
import studio.wetrack.accountService.AccountService;
import studio.wetrack.accountService.SmsCodeService;
import studio.wetrack.accountService.auth.domain.Token;
import studio.wetrack.accountService.auth.domain.User;
import studio.wetrack.accountService.auth.service.TokenService;
import studio.wetrack.accountService.domain.ChangePass;
import studio.wetrack.accountService.domain.LoginForm;
import studio.wetrack.accountService.domain.LoginOut;
import studio.wetrack.accountService.domain.ResetPass;
import studio.wetrack.accountService.domain.Signup;
import studio.wetrack.accountService.domain.SmartLoginForm;
import studio.wetrack.accountService.domain.Type;
import studio.wetrack.base.exception.SmsCodeException;
import studio.wetrack.base.utils.RegExUtil;

public abstract class AbstrackAccountService
implements AccountService {
    TokenService tokenService;
    SmsCodeService smsCodeService;

    public AbstrackAccountService(TokenService tokenService, SmsCodeService smsCodeService) {
        this.tokenService = tokenService;
        this.smsCodeService = smsCodeService;
    }

    @Override
    public LoginOut login(SmartLoginForm form) throws AccountException {
        if (StringUtils.isEmpty((Object)form.getAccount())) {
            throw new AccountException("\u65e0\u6548\u7684\u7528\u6237");
        }
        LoginForm lf = new LoginForm();
        if (RegExUtil.isMobilePhone((String)form.getAccount())) {
            lf.setPhone(form.getAccount());
        } else if (RegExUtil.isValidEmail((String)form.getAccount())) {
            lf.setEmail(form.getAccount());
        } else {
            lf.setUserName(form.getAccount());
        }
        lf.setPassword(form.getPassword());
        return this.login(form);
    }

    @Override
    public LoginOut login(LoginForm form) throws AccountException {
        if (StringUtils.isEmpty((Object)form.getEmail()) && StringUtils.isEmpty((Object)form.getPhone()) && StringUtils.isEmpty((Object)form.getWeixinId())) {
            throw new AccountException("\u65e0\u6548\u7684\u7528\u6237");
        }
        if (StringUtils.isEmpty((Object)form.getPassword())) {
            throw new AccountException("\u6ca1\u6709\u8f93\u5165\u5bc6\u7801");
        }
        String id = this.findUserAndCheckPassAndReturnId(form);
        if (id == null) {
            throw new AccountException("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef");
        }
        User user = form.getType() == null ? new User(id, form.getPassword(), this.getLoginLifeTime(form), new String[0]) : new User(form.getType().getName() + "_" + id, form.getPassword(), this.getLoginLifeTime(form), form.getType().getRolesStringArray());
        Token token = this.tokenService.login(user);
        LoginOut loginOut = new LoginOut();
        loginOut.setId(id);
        loginOut.setToken(token.getToken());
        return loginOut;
    }

    @Override
    public LoginOut quickLogin(LoginForm form) throws AccountException {
        if (StringUtils.isEmpty((Object)form.getPhone())) {
            throw new AccountException("\u8bf7\u8f93\u5165\u624b\u673a");
        }
        if (!RegExUtil.isMobilePhone((String)form.getPhone())) {
            throw new AccountException("\u65e0\u6548\u7684\u624b\u673a\u53f7\u7801");
        }
        if (StringUtils.isEmpty((Object)form.getSmsCode())) {
            throw new AccountException("\u8bf7\u8f93\u5165\u624b\u673a\u9a8c\u8bc1\u7801");
        }
        String id = this.findUserAndReturnId(form);
        if (id == null) {
            throw new AccountException("\u4e0d\u5b58\u5728\u8be5\u7528\u6237");
        }
        if (!this.checkSmsCodeForLogin(form.getPhone(), form.getSmsCode())) {
            throw new AccountException("\u9a8c\u8bc1\u7801\u65e0\u6548");
        }
        this.smsCodeService.removeSmsCode(form.getPhone(), form.getSmsCode(), SmsCodeService.CodeType.LOGIN);
        User user = form.getType() == null ? new User(id, form.getSmsCode(), this.getLoginLifeTime(form), new String[0]) : new User(form.getType().getName() + "_" + id, form.getSmsCode(), this.getLoginLifeTime(form), form.getType().getRolesStringArray());
        Token token = this.tokenService.login(user);
        LoginOut loginOut = new LoginOut();
        loginOut.setId(id);
        loginOut.setToken(token.getToken());
        return loginOut;
    }

    protected abstract int getLoginLifeTime(LoginForm var1) throws AccountException;

    protected abstract String findUserAndCheckPassAndReturnId(LoginForm var1) throws AccountException;

    protected abstract String findUserAndReturnId(LoginForm var1) throws AccountException;

    @Override
    public void logout(LoginOut form) throws AccountException {
        if (StringUtils.isEmpty((Object)form.getId())) {
            throw new AccountException("\u7528\u6237id\u65e0\u6548");
        }
        if (StringUtils.isEmpty((Object)form.getToken())) {
            throw new AccountException("\u60a8\u6ca1\u6709token\uff0c\u662f\u5426\u5df2\u7ecf\u767b\u5f55\uff1f");
        }
        this.tokenService.logout(form.getToken());
    }

    @Override
    public void changePass(ChangePass form) throws AccountException {
        if (StringUtils.isEmpty((Object)form.getId())) {
            throw new AccountException("\u7528\u6237id\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)form.getOldPass())) {
            throw new AccountException("\u8bf7\u8f93\u5165\u539f\u6765\u7684\u5bc6\u7801");
        }
        if (StringUtils.isEmpty((Object)form.getNewPass())) {
            throw new AccountException("\u8bf7\u8f93\u5165\u65b0\u7684\u5bc6\u7801");
        }
        if (!this.checkPassword(form.getId(), form.getOldPass(), form.getType())) {
            throw new AccountException("\u539f\u5bc6\u7801\u9519\u8bef");
        }
        this.updatePassword(form.getId(), form.getNewPass(), form.getType());
    }

    protected abstract void updatePassword(String var1, String var2, Type var3) throws AccountException;

    protected abstract boolean checkPassword(String var1, String var2, Type var3) throws AccountException;

    @Override
    public void resetPass(ResetPass form) throws AccountException {
        if (StringUtils.isEmpty((Object)form.getVerification())) {
            throw new AccountException("\u8bf7\u63d0\u4f9b\u9a8c\u8bc1\u7801");
        }
        if (StringUtils.isEmpty((Object)form.getEmail()) && StringUtils.isEmpty((Object)form.getPhone())) {
            throw new AccountException("\u65e0\u6548\u7684\u7528\u6237");
        }
        if (this.checkSmsCodeForResetPass(form.getPhone(), form.getVerification())) {
            if (!StringUtils.isEmpty((Object)form.getPhone())) {
                this.updatePasswordByPhone(form.getPhone(), form.getNewPass(), form.getType());
            } else {
                this.updatePasswordByEmail(form.getEmail(), form.getNewPass(), form.getType());
            }
        } else {
            throw new AccountException("\u65e0\u6548\u7684\u9a8c\u8bc1\u7801");
        }
    }

    protected abstract void updatePasswordByEmail(String var1, String var2, Type var3) throws AccountException;

    protected abstract void updatePasswordByPhone(String var1, String var2, Type var3) throws AccountException;

    @Override
    public String signup(Signup form) throws AccountException {
        return null;
    }

    @Override
    public void requestSmsCodeForResetPass(String phone) throws SmsCodeException {
        this.smsCodeService.requestSmsCode(phone, SmsCodeService.CodeType.RESET_PASS);
    }

    @Override
    public boolean checkSmsCodeForResetPass(String phone, String code) {
        return this.smsCodeService.checkSmsCode(phone, code, SmsCodeService.CodeType.RESET_PASS, true);
    }

    @Override
    public void requestSmsCodeForLogin(String phone) throws SmsCodeException {
        this.smsCodeService.requestSmsCode(phone, SmsCodeService.CodeType.LOGIN);
    }

    @Override
    public boolean checkSmsCodeForLogin(String phone, String code) {
        return this.smsCodeService.checkSmsCode(phone, code, SmsCodeService.CodeType.LOGIN, false);
    }

    public TokenService getTokenService() {
        return this.tokenService;
    }

    public void setTokenService(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    public SmsCodeService getSmsCodeService() {
        return this.smsCodeService;
    }

    public void setSmsCodeService(SmsCodeService smsCodeService) {
        this.smsCodeService = smsCodeService;
    }
}

