/*
 * Decompiled with CFR 0.152.
 */
package studio.wetrack.accountService;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import studio.wetrack.accountService.SmsCodeService;
import studio.wetrack.base.exception.SmsCodeException;
import studio.wetrack.base.utils.sms.SmsService;

public class DefaultSmsCodeServiceImpl
implements SmsCodeService {
    static final long VALID_TIME = 300L;
    static final String PREFIX = "SMSCODE_";
    SmsService smsService;
    RedisTemplate<String, String> codeStoreTemplate;
    Map<SmsCodeService.CodeType, Long> validTimeMap = new HashMap<SmsCodeService.CodeType, Long>();

    public DefaultSmsCodeServiceImpl(SmsService smsService, RedisTemplate<String, String> codeStoreTemplate) {
        this.smsService = smsService;
        this.codeStoreTemplate = codeStoreTemplate;
        this.validTimeMap.put(SmsCodeService.CodeType.LOGIN, 300L);
        this.validTimeMap.put(SmsCodeService.CodeType.RESET_PASS, 300L);
        this.validTimeMap.put(SmsCodeService.CodeType.SIGNUP, 300L);
    }

    @Override
    public void requestSmsCode(String phone, SmsCodeService.CodeType type) throws SmsCodeException {
        BoundValueOperations op = this.codeStoreTemplate.boundValueOps((Object)(PREFIX + (Object)((Object)type) + "_" + phone));
        String found = (String)op.get();
        String code = this.smsService.sendCode(phone, found);
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new SmsCodeException("\u9a8c\u8bc1\u7801\u83b7\u53d6\u5931\u8d25");
        }
        if (found == null) {
            op.set((Object)code);
            op.expire(this.validTimeMap.get((Object)type).longValue(), TimeUnit.SECONDS);
        }
    }

    @Override
    public boolean checkSmsCode(String phone, String code, SmsCodeService.CodeType type, boolean deleteAfterMatch) {
        BoundValueOperations op = this.codeStoreTemplate.boundValueOps((Object)(PREFIX + (Object)((Object)type) + "_" + phone));
        String found = (String)op.get();
        if (found == null || !code.equals(found)) {
            return false;
        }
        if (deleteAfterMatch) {
            this.removeSmsCode(phone, code, type);
        }
        return true;
    }

    @Override
    public boolean removeSmsCode(String phone, String code, SmsCodeService.CodeType type) {
        this.codeStoreTemplate.delete((Object)(PREFIX + (Object)((Object)type) + "_" + phone));
        return true;
    }

    @Override
    public long getCodeValidTimeForType(SmsCodeService.CodeType type) {
        return this.validTimeMap.get((Object)type);
    }

    @Override
    public long setCodeValidTimeForType(SmsCodeService.CodeType type, long time) {
        return this.validTimeMap.put(type, time);
    }
}

