/*
 * Decompiled with CFR 0.152.
 */
package studio.wetrack.accountService.auth.domain;

import java.io.Serializable;
import java.util.Date;
import studio.wetrack.accountService.auth.domain.User;

public class Token
implements Serializable {
    private long created = System.currentTimeMillis();
    private final String token;
    private User user;
    private boolean loggedout;

    public Token(String token, User user) {
        this.token = token;
        this.user = user;
    }

    public String getToken() {
        return this.token;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isExpired() {
        return !this.user.isNeverExpired() && (System.currentTimeMillis() - this.created) / 1000L > (long)this.user.getLoginLifeTime();
    }

    public boolean isLoggedout() {
        return this.loggedout;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public void setLoggedout(boolean loggedout) {
        this.loggedout = loggedout;
    }

    public String toString() {
        return "token='" + this.token + '\'' + ", User : " + this.user + ", created=" + new Date(this.created) + '}';
    }
}

