/*
 * Decompiled with CFR 0.152.
 */
package studio.wetrack.accountService.auth.domain;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import studio.wetrack.accountService.auth.domain.SimpleGrantedAuthority;

public class User
implements UserDetails {
    public static final int NEVER_EXPIRED = -1;
    String id;
    String password;
    int loginLifeTime;
    Collection<GrantedAuthority> roles;
    public static String ROLE_FULL = "full";

    public static void setFullRoleName(String fullRole) {
        ROLE_FULL = fullRole;
    }

    public User(String id, String password, int loginLifeTime, String ... roles) {
        this.id = id;
        this.password = password;
        this.loginLifeTime = loginLifeTime;
        this.roles = new ArrayList<GrantedAuthority>();
        if (roles != null) {
            for (String r : roles) {
                this.roles.add(new SimpleGrantedAuthority(r));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean hasRole(String role) {
        if (role.equals(ROLE_FULL)) {
            return true;
        }
        for (GrantedAuthority r : this.roles) {
            if (!r.getAuthority().equals(role)) continue;
            return true;
        }
        return false;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.roles;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.id;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public int getLoginLifeTime() {
        return this.loginLifeTime;
    }

    public void setLoginLifeTime(int loginLifeTime) {
        this.loginLifeTime = loginLifeTime;
    }

    public boolean isNeverExpired() {
        return this.loginLifeTime == -1;
    }

    public String toString() {
        String s = "";
        for (GrantedAuthority r : this.roles) {
            s = s + r.getAuthority() + " ";
        }
        return "id " + this.id + ", roles " + s;
    }
}

