/*
 * Decompiled with CFR 0.152.
 */
package studio.wetrack.accountService.auth.service;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import studio.wetrack.accountService.auth.domain.Token;
import studio.wetrack.accountService.auth.domain.User;
import studio.wetrack.accountService.auth.service.TokenStorageService;
import studio.wetrack.base.utils.common.UUIDGenerator;

public class TokenService {
    TokenStorageService tokenStorageService;
    boolean onlyOnePermitted = true;

    @Autowired
    public TokenService(TokenStorageService tokenStorageService) {
        this.tokenStorageService = tokenStorageService;
    }

    public Token login(User user) {
        return this.doLogin(user);
    }

    public Token login(String id, String password) {
        return this.doLogin(new User(id, password, -1, User.ROLE_FULL));
    }

    public Token login(String id, String password, int loginLifeTime) {
        return this.doLogin(new User(id, password, loginLifeTime, User.ROLE_FULL));
    }

    public boolean updateToken(Token token) {
        return this.tokenStorageService.updateToken(token);
    }

    private Token doLogin(User user) {
        Collection<Token> tokens = this.tokenStorageService.findAllByUserId(user.getId());
        ArrayList<Token> copiedTokens = new ArrayList<Token>();
        copiedTokens.addAll(tokens);
        String tokenString = UUIDGenerator.generate().toUpperCase();
        Token token = new Token(tokenString, user);
        this.addToken(token);
        if (tokens != null) {
            for (Token exist : copiedTokens) {
                if (!exist.isExpired() && !exist.isLoggedout() && !this.isOnlyOnePermitted()) continue;
                this.tokenStorageService.removeByTokenString(exist.getToken());
            }
        }
        return token;
    }

    public void logout(String token) {
        this.removeByTokenString(token);
    }

    private boolean addToken(Token token) {
        return this.tokenStorageService.addToken(token);
    }

    private Token removeByTokenString(String tokenString) {
        return this.tokenStorageService.removeByTokenString(tokenString);
    }

    public Token findByTokenString(String tokenString) {
        return this.tokenStorageService.findByTokenString(tokenString);
    }

    public Collection<Token> findAllByUserId(String userId) {
        return this.tokenStorageService.findAllByUserId(userId);
    }

    public boolean isOnlyOnePermitted() {
        return this.onlyOnePermitted;
    }

    public void setOnlyOnePermitted(boolean onlyOnePermitted) {
        this.onlyOnePermitted = onlyOnePermitted;
    }
}

