/*
 * Decompiled with CFR 0.152.
 */
package studio.wetrack.accountService.auth.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import studio.wetrack.accountService.auth.domain.Token;
import studio.wetrack.accountService.auth.service.TokenStorageService;

public class TokenInMemoryStorageService
implements TokenStorageService {
    private Map<String, Token> tokenKeyMap = new HashMap<String, Token>();
    private Map<String, Map<String, Token>> userIdKeyMap = new HashMap<String, Map<String, Token>>();

    @Override
    public boolean addToken(Token token) {
        this.tokenKeyMap.put(token.getToken(), token);
        Map<String, Token> userTokenMap = this.userIdKeyMap.get(token.getUser().getId());
        if (userTokenMap == null) {
            userTokenMap = new HashMap<String, Token>();
            this.userIdKeyMap.put(token.getUser().getId(), userTokenMap);
        }
        userTokenMap.put(token.getToken(), token);
        return true;
    }

    @Override
    public boolean updateToken(Token token) {
        return true;
    }

    @Override
    public Token removeByTokenString(String tokenString) {
        Map<String, Token> userTokenMap;
        Token token = this.tokenKeyMap.get(tokenString);
        this.tokenKeyMap.remove(tokenString);
        if (token != null && (userTokenMap = this.userIdKeyMap.get(token.getUser().getId())) != null) {
            userTokenMap.remove(tokenString);
        }
        return token;
    }

    @Override
    public Token findByTokenString(String tokenString) {
        return this.tokenKeyMap.get(tokenString);
    }

    @Override
    public Collection<Token> findAllByUserId(String userId) {
        Map<String, Token> userTokenMap = this.userIdKeyMap.get(userId);
        if (userTokenMap != null) {
            return userTokenMap.values();
        }
        return null;
    }
}

