/*
 * Decompiled with CFR 0.152.
 */
package studio.wetrack.accountService.auth.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.security.core.GrantedAuthority;
import studio.wetrack.accountService.auth.domain.Token;
import studio.wetrack.accountService.auth.domain.User;
import studio.wetrack.accountService.auth.service.TokenStorageService;

public class TokenRedisStorageService
implements TokenStorageService {
    static final String TOKEN_HASH_KEY = "TOKEN_HASH";
    static final String USER_TOKEN_HASH_KEY_PREFIX = "USER_TOKEN_HASH_";
    RedisTemplate<String, Token> redisTemplate;
    BoundHashOperations<String, String, Token> tokenHashOps;

    @Autowired
    public TokenRedisStorageService(RedisTemplate<String, Token> redisTemplate) {
        this.redisTemplate = redisTemplate;
        redisTemplate.setValueSerializer((RedisSerializer)TokenSerializer.INSTANCE);
        redisTemplate.setHashValueSerializer((RedisSerializer)TokenSerializer.INSTANCE);
        this.tokenHashOps = redisTemplate.boundHashOps((Object)TOKEN_HASH_KEY);
    }

    @Override
    public boolean addToken(Token token) {
        this.tokenHashOps.put((Object)token.getToken(), (Object)token);
        BoundHashOperations userHashOps = this.redisTemplate.boundHashOps((Object)(USER_TOKEN_HASH_KEY_PREFIX + token.getUser().getId()));
        userHashOps.put((Object)token.getToken(), (Object)token);
        return true;
    }

    @Override
    public boolean updateToken(Token token) {
        this.tokenHashOps.delete(new Object[]{token.getToken()});
        this.tokenHashOps.put((Object)token.getToken(), (Object)token);
        BoundHashOperations userHashOps = this.redisTemplate.boundHashOps((Object)(USER_TOKEN_HASH_KEY_PREFIX + token.getUser().getId()));
        userHashOps.delete(new Object[]{token.getToken()});
        userHashOps.put((Object)token.getToken(), (Object)token);
        return false;
    }

    @Override
    public Token removeByTokenString(String tokenString) {
        Token token = (Token)this.tokenHashOps.get((Object)tokenString);
        this.tokenHashOps.delete(new Object[]{tokenString});
        BoundHashOperations userHashOps = this.redisTemplate.boundHashOps((Object)(USER_TOKEN_HASH_KEY_PREFIX + token.getUser().getId()));
        userHashOps.delete(new Object[]{tokenString});
        return token;
    }

    @Override
    public Token findByTokenString(String tokenString) {
        return (Token)this.tokenHashOps.get((Object)tokenString);
    }

    @Override
    public Collection<Token> findAllByUserId(String userId) {
        BoundHashOperations userHashOps = this.redisTemplate.boundHashOps((Object)(USER_TOKEN_HASH_KEY_PREFIX + userId));
        return userHashOps.values();
    }

    public static void main(String[] args) {
        String tokenString = "tokenString 16743829012322 false id password -1";
        Token token = TokenSerializer.INSTANCE.deserialize(tokenString.getBytes(StandardCharsets.UTF_8));
        System.out.println("deserialized token " + token.toString());
        System.out.println("seriazlied token " + new String(TokenSerializer.INSTANCE.serialize(token), StandardCharsets.UTF_8));
    }

    public static enum TokenSerializer implements RedisSerializer<Token>
    {
        INSTANCE;

        private static String BLANK;
        private static final int MIN_PARTS_LENGTH = 6;

        public byte[] serialize(Token token) throws SerializationException {
            if (token == null) {
                throw new SerializationException("null object for token");
            }
            StringBuilder builder = new StringBuilder();
            builder.append(token.getToken()).append(BLANK).append(token.getCreated()).append(BLANK).append(token.isLoggedout()).append(BLANK).append(token.getUser().getId()).append(BLANK).append(token.getUser().getPassword()).append(BLANK).append(token.getUser().getLoginLifeTime()).append(BLANK);
            if (token.getUser().getAuthorities() != null) {
                for (GrantedAuthority grantedAuthority : token.getUser().getAuthorities()) {
                    builder.append(grantedAuthority.getAuthority()).append(" ");
                }
            }
            String tokenSerialized = builder.toString();
            return tokenSerialized.getBytes(StandardCharsets.UTF_8);
        }

        public Token deserialize(byte[] bytes) throws SerializationException {
            if (bytes == null) {
                return null;
            }
            String serializedString = new String(bytes, StandardCharsets.UTF_8);
            String[] parts = serializedString.split(BLANK);
            if (parts.length < 6) {
                throw new SerializationException("deserialize token error, content length is " + parts.length + ", require at least " + 6);
            }
            User user = null;
            if (parts.length > 6) {
                List<String> roles = Arrays.asList(parts).subList(6, parts.length);
                user = new User(parts[3], parts[4], Integer.valueOf(parts[5]), roles.toArray(new String[roles.size()]));
            } else {
                user = new User(parts[3], parts[4], Integer.valueOf(parts[5]), new String[0]);
            }
            Token token = new Token(parts[0], user);
            token.setCreated(Long.valueOf(parts[1]));
            token.setLoggedout(Boolean.valueOf(parts[2]));
            return token;
        }

        static {
            BLANK = " ";
        }
    }
}

