/*
 * Decompiled with CFR 0.152.
 */
package su.izotov.java.ddispatch;

import java.lang.reflect.Method;
import java.util.Set;
import su.izotov.java.ddispatch.MethodsSource;

class ByParameterClass
implements MethodsSource {
    private final Class<?> guestClass;
    private final Class<?> returnClassRestriction;
    private final Class<?> masterClass;
    private final String methodName;
    private final MethodsSource nextMethodsSource;

    ByParameterClass(Class<?> masterClass, Class<?> guestClass, String methodName, Class<?> returnClass, MethodsSource nextMethodsSource) {
        this.guestClass = guestClass;
        this.returnClassRestriction = returnClass;
        this.masterClass = masterClass;
        this.methodName = methodName;
        this.nextMethodsSource = nextMethodsSource;
    }

    @Override
    public final Set<Method> findMethods() {
        return ByParameterClass.findMethods(this.masterClass, this.guestClass, this.methodName, this.returnClassRestriction, this.nextMethodsSource);
    }

    public static Set<Method> findMethods(Class<?> masterClass, Class<?> guestClass, String methodName, Class<?> returnClass, MethodsSource nextMethodsSource) {
        Set<Method> methods = nextMethodsSource.findMethods();
        try {
            Method method = masterClass.getMethod(methodName, guestClass);
            if (returnClass.isAssignableFrom(method.getReturnType())) {
                methods.add(method);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return methods;
    }
}

