/*
 * Decompiled with CFR 0.152.
 */
package su.izotov.java.ddispatch;

import java.lang.reflect.Method;
import java.util.Set;
import su.izotov.java.ddispatch.EmptyMethods;
import su.izotov.java.ddispatch.MethodsSource;

class ByParameterInterfaces
implements MethodsSource {
    private final Class<?> guestClass;
    private final Class<?> returnClass;
    private final Class<?> masterClass;
    private final String methodName;
    private final MethodsSource nextMethodsSource;

    ByParameterInterfaces(Class<?> masterClass, Class<?> guestClass, String methodName, Class<?> returnClass, MethodsSource nextMethodsSource) {
        this.guestClass = guestClass;
        this.returnClass = returnClass;
        this.masterClass = masterClass;
        this.methodName = methodName;
        this.nextMethodsSource = nextMethodsSource;
    }

    private static Set<Method> findMethod(Class<?> guestClass, Class<?> masterClass, String methodName, Class<?> returnClass, MethodsSource nextMethodsSource) {
        Set<Method> methods = nextMethodsSource.findMethods();
        EmptyMethods emptyMethods = new EmptyMethods();
        for (Class<?> guestInterface : guestClass.getInterfaces()) {
            try {
                Method method = masterClass.getMethod(methodName, guestInterface);
                if (returnClass.isAssignableFrom(method.getReturnType())) {
                    methods.add(method);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            methods.addAll(ByParameterInterfaces.findMethod(masterClass, guestInterface, methodName, returnClass, emptyMethods));
        }
        return methods;
    }

    @Override
    public final Set<Method> findMethods() {
        return ByParameterInterfaces.findMethod(this.guestClass, this.masterClass, this.methodName, this.returnClass, this.nextMethodsSource);
    }
}

