/*
 * Decompiled with CFR 0.152.
 */
package su.izotov.java.ddispatch;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import ru.vyarus.java.generics.resolver.GenericsResolver;
import ru.vyarus.java.generics.resolver.context.TypeGenericsContext;
import su.izotov.java.ddispatch.ByParameterClass;
import su.izotov.java.ddispatch.ByParameterInterfaces;
import su.izotov.java.ddispatch.ByParameterSuperClass;
import su.izotov.java.ddispatch.EmptyMethods;
import su.izotov.java.ddispatch.methods.MethodAmbiguouslyDefinedException;
import su.izotov.java.ddispatch.methods.MethodRepresentation;
import su.izotov.java.ddispatch.methods.OneMethod;
import su.izotov.java.ddispatch.methods.OneOfTwoMethods;

public class Dispatch<M, G, R> {
    private final String methodName;
    private final M master;
    private final G guest;
    private final BiFunction<M, G, R> defaultMethod;

    protected Dispatch(M master, G guest, String methodName, BiFunction<M, G, R> defaultMethod) {
        this.master = master;
        this.guest = guest;
        this.methodName = methodName;
        this.defaultMethod = defaultMethod;
    }

    public final R invoke() throws InvocationTargetException, IllegalAccessException, MethodAmbiguouslyDefinedException {
        Object ret;
        TypeGenericsContext context;
        Class returnClass;
        Class<?> guestClass;
        Class<?> masterClass = this.master.getClass();
        Set<Method> methods = new ByParameterClass(masterClass, guestClass = this.guest.getClass(), this.methodName, returnClass = (Class)(context = GenericsResolver.resolve(this.getClass(), (Class[])new Class[0]).type(Dispatch.class)).generics().get(2), new ByParameterInterfaces(masterClass, guestClass, this.methodName, returnClass, new ByParameterSuperClass(masterClass, guestClass, this.methodName, returnClass, new EmptyMethods()))).findMethods();
        if (methods.isEmpty()) {
            ret = this.defaultMethod.apply(this.master, this.guest);
        } else {
            Iterator<Method> iterator = methods.iterator();
            MethodRepresentation currentMethod = new OneMethod(iterator.next());
            while (iterator.hasNext()) {
                OneMethod nextMethod = new OneMethod(iterator.next());
                currentMethod = new OneOfTwoMethods(currentMethod, nextMethod);
            }
            ret = currentMethod.toMethod().invoke(this.master, this.guest);
        }
        return ret;
    }
}

