/*
 * Decompiled with CFR 0.152.
 */
package su.izotov.java.ddispatch.methods;

import java.lang.reflect.Method;
import su.izotov.java.ddispatch.methods.GuestOf;
import su.izotov.java.ddispatch.methods.MasterOf;
import su.izotov.java.ddispatch.methods.MethodAmbiguouslyDefinedException;
import su.izotov.java.ddispatch.methods.MethodRepresentation;

public class OneOfTwoMethods
implements MethodRepresentation {
    private final MethodRepresentation firstMethod;
    private final MethodRepresentation secondMethod;

    public OneOfTwoMethods(MethodRepresentation firstMethod, MethodRepresentation secondMethod) {
        this.firstMethod = firstMethod;
        this.secondMethod = secondMethod;
    }

    @Override
    public final Method toMethod() throws MethodAmbiguouslyDefinedException {
        Method ret;
        GuestOf guestOfOne = new GuestOf(this.firstMethod);
        GuestOf guestOfTwo = new GuestOf(this.secondMethod);
        MasterOf masterOfOne = new MasterOf(this.firstMethod);
        MasterOf masterOfTwo = new MasterOf(this.secondMethod);
        if (guestOfOne.isSubtypeOf(guestOfTwo)) {
            ret = this.firstMethod.toMethod();
        } else if (guestOfTwo.isSubtypeOf(guestOfOne)) {
            ret = this.secondMethod.toMethod();
        } else if (((Object)guestOfOne).equals(guestOfTwo)) {
            ret = masterOfOne.isSubtypeOf(masterOfTwo) ? this.firstMethod.toMethod() : (masterOfTwo.isSubtypeOf(masterOfOne) ? this.secondMethod.toMethod() : this.firstMethod.toMethod());
        } else {
            throw new MethodAmbiguouslyDefinedException(this.firstMethod.toMethod(), this.secondMethod.toMethod());
        }
        return ret;
    }
}

