/*
 * Decompiled with CFR 0.152.
 */
package su.litvak.chromecast.api.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import su.litvak.chromecast.api.v2.Item;
import su.litvak.chromecast.api.v2.Media;
import su.litvak.chromecast.api.v2.Volume;

public class MediaStatus {
    public final List<Integer> activeTrackIds;
    public final long mediaSessionId;
    public final int playbackRate;
    public final PlayerState playerState;
    public final Integer currentItemId;
    public final double currentTime;
    public final Map<String, Object> customData;
    public final Integer loadingItemId;
    public final List<Item> items;
    public final Integer preloadedItemId;
    public final int supportedMediaCommands;
    public final Volume volume;
    public final Media media;
    public final RepeatMode repeatMode;
    public final IdleReason idleReason;

    MediaStatus(@JsonProperty(value="activeTrackIds") List<Integer> activeTrackIds, @JsonProperty(value="mediaSessionId") long mediaSessionId, @JsonProperty(value="playbackRate") int playbackRate, @JsonProperty(value="playerState") PlayerState playerState, @JsonProperty(value="currentItemId") Integer currentItemId, @JsonProperty(value="currentTime") double currentTime, @JsonProperty(value="customData") Map<String, Object> customData, @JsonProperty(value="loadingItemId") Integer loadingItemId, @JsonProperty(value="items") List<Item> items, @JsonProperty(value="preloadedItemId") Integer preloadedItemId, @JsonProperty(value="supportedMediaCommands") int supportedMediaCommands, @JsonProperty(value="volume") Volume volume, @JsonProperty(value="media") Media media, @JsonProperty(value="repeatMode") RepeatMode repeatMode, @JsonProperty(value="idleReason") IdleReason idleReason) {
        this.activeTrackIds = activeTrackIds != null ? Collections.unmodifiableList(activeTrackIds) : null;
        this.mediaSessionId = mediaSessionId;
        this.playbackRate = playbackRate;
        this.playerState = playerState;
        this.currentItemId = currentItemId;
        this.currentTime = currentTime;
        this.customData = customData != null ? Collections.unmodifiableMap(customData) : null;
        this.loadingItemId = loadingItemId;
        this.items = items != null ? Collections.unmodifiableList(items) : null;
        this.preloadedItemId = preloadedItemId;
        this.supportedMediaCommands = supportedMediaCommands;
        this.volume = volume;
        this.media = media;
        this.repeatMode = repeatMode;
        this.idleReason = idleReason;
    }

    public final String toString() {
        String activeTrackIdsString = this.activeTrackIds == null ? "<null>" : Arrays.toString(this.activeTrackIds.toArray());
        String itemsString = this.items == null ? "<null>" : Arrays.toString(this.items.toArray());
        String customDataString = this.customData == null ? "<null>" : Arrays.toString(this.customData.keySet().toArray());
        return String.format("MediaStatus{activeTrackIds: %s, mediaSessionId: %d, playbackRate: %d, playerState: %s, currentItemId: %s, currentTime: %f, customData: %s, loadingItemId: %s, items: %s, preloadedItemId: %s, supportedMediaCommands: %d, volume: %s, media: %s, repeatMode: %s, idleReason: %s}", new Object[]{activeTrackIdsString, this.mediaSessionId, this.playbackRate, this.playerState, this.currentItemId, this.currentTime, customDataString, this.loadingItemId, itemsString, this.preloadedItemId, this.supportedMediaCommands, this.volume, this.media, this.repeatMode, this.idleReason});
    }

    public static enum IdleReason {
        CANCELLED,
        INTERRUPTED,
        FINISHED,
        ERROR,
        COMPLETED;

    }

    public static enum RepeatMode {
        REPEAT_OFF,
        REPEAT_ALL,
        REPEAT_SINGLE,
        REPEAT_ALL_AND_SHUFFLE;

    }

    public static enum PlayerState {
        IDLE,
        BUFFERING,
        PLAYING,
        PAUSED,
        LOADING;

    }
}

