/*
 * Decompiled with CFR 0.152.
 */
package su.litvak.chromecast.api.v2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import su.litvak.chromecast.api.v2.Application;
import su.litvak.chromecast.api.v2.Volume;

public class Status {
    public final Volume volume;
    public final List<Application> applications;
    public final boolean activeInput;
    public final boolean standBy;

    Status(@JsonProperty(value="volume") Volume volume, @JsonProperty(value="applications") List<Application> applications, @JsonProperty(value="isActiveInput") boolean activeInput, @JsonProperty(value="isStandBy") boolean standBy) {
        this.volume = volume;
        this.applications = applications == null ? Collections.emptyList() : applications;
        this.activeInput = activeInput;
        this.standBy = standBy;
    }

    @JsonIgnore
    public final Application getRunningApp() {
        return this.applications.isEmpty() ? null : this.applications.get(0);
    }

    public final boolean isAppRunning(String appId) {
        return this.getRunningApp() != null && this.getRunningApp().id.equals(appId);
    }

    public final String toString() {
        String applicationsString = this.applications == null ? "<null>" : Arrays.toString(this.applications.toArray());
        return String.format("Media{volume: %s, applications: %s, activeInput: %b, standBy; %b}", this.volume, applicationsString, this.activeInput, this.standBy);
    }
}

