/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.mapper;

import com.subshell.persistence.exception.InitializationException;
import com.subshell.persistence.exception.PersistenceException;
import com.subshell.persistence.mapper.PersistenceMapper;
import com.subshell.persistence.mapper.PersistenceMapperConfiguration;
import com.subshell.persistence.mapper.PersistenceMapperFactory;
import com.subshell.persistence.mapper.TransactionPersistenceMapper;
import com.subshell.persistence.transaction.Transaction;
import com.subshell.persistence.transaction.TransactionFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class TransactionPersistenceMapperFactory
implements PersistenceMapperFactory {
    private PersistenceMapperConfiguration configuration;
    private TransactionFactory transactionFactory;

    public TransactionPersistenceMapperFactory(PersistenceMapperConfiguration configuration, TransactionFactory transactionFactory) {
        this.configuration = configuration;
        this.transactionFactory = transactionFactory;
    }

    public PersistenceMapper getMapper(Class clazz) {
        Class mapperClass;
        try {
            mapperClass = this.configuration.getMapperForClass(clazz);
        }
        catch (PersistenceException e) {
            throw new InitializationException("couldn't get persistence mapper class for objects class " + clazz.getName(), e);
        }
        if (mapperClass == null) {
            throw new InitializationException("couldn't get persistence mapper class for objects class " + clazz.getName());
        }
        if (!TransactionPersistenceMapper.class.isAssignableFrom(mapperClass)) {
            throw new InitializationException("class " + mapperClass.getName() + " is not a TransactionPersistenceMapper");
        }
        Constructor constructor = null;
        try {
            constructor = mapperClass.getConstructor(Class.class, Transaction.class);
        }
        catch (SecurityException e) {
            throw new InitializationException("cannot access constructor of class " + mapperClass.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new InitializationException("required constructor not found in class " + mapperClass.getName(), e);
        }
        if (constructor == null) {
            throw new InitializationException("required constructor not found in class " + mapperClass.getName());
        }
        Transaction tx = null;
        try {
            tx = this.transactionFactory.getTransaction();
        }
        catch (PersistenceException e) {
            throw new InitializationException("couldn't get a transaction", e);
        }
        if (tx == null) {
            throw new InitializationException("couldn't get a transaction (unknown reason)");
        }
        try {
            return (PersistenceMapper)constructor.newInstance(clazz, tx);
        }
        catch (IllegalArgumentException e) {
            throw new InitializationException("error while invoking constructor of class " + mapperClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new InitializationException("error while invoking constructor of class " + mapperClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new InitializationException("cannot access constructor of class " + mapperClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new InitializationException("error while invoking constructor of class " + mapperClass.getName(), e);
        }
    }
}

