/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.oracle;

import com.subshell.persistence.oracle.FileUtil;
import com.subshell.persistence.oracle.PreparedStatementWrapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class OracleHackedPreparedStatement
extends PreparedStatementWrapper {
    protected ParsedStatement parsedStatement = null;
    protected List lobs = new LinkedList();
    protected String sql;
    private static final byte[] BLANK_BINARY = new byte[]{32};
    public static final int TYPE_CLOB = 0;
    public static final int TYPE_BLOB = 1;

    public OracleHackedPreparedStatement(OraclePreparedStatement ps, String sql) {
        super((PreparedStatement)ps);
        this.sql = sql;
    }

    public OraclePreparedStatement getOraclePreparedStatement() {
        return (OraclePreparedStatement)this.getWrappedPreparedStatement();
    }

    public void setClob(int i, Clob x) throws SQLException {
        if (this.parsedStatement == null) {
            this.parsedStatement = new ParsedStatement(this.sql);
            this.lobs = new LinkedList();
        }
        this.setString(i, " ");
        this.lobs.add(new OracleHackedLob(this.parsedStatement.columns[i - 1], x));
    }

    public void setString(int i, String x) throws SQLException {
        super.setString(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        if (this.parsedStatement == null) {
            this.parsedStatement = new ParsedStatement(this.sql);
            this.lobs = new LinkedList();
        }
        super.setBytes(i, BLANK_BINARY);
        this.lobs.add(new OracleHackedLob(this.parsedStatement.columns[i - 1], x));
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet rs = super.executeQuery();
        this.executeLobHack();
        return rs;
    }

    public int executeUpdate() throws SQLException {
        int i = super.executeUpdate();
        this.executeLobHack();
        return i;
    }

    public boolean execute() throws SQLException {
        boolean b = super.execute();
        this.executeLobHack();
        return b;
    }

    public int[] executeBatch() throws SQLException {
        int[] i = super.executeBatch();
        this.executeLobHack();
        return i;
    }

    protected void executeLobHack() throws SQLException {
        try {
            if (this.lobs != null && this.lobs.size() > 0 && this.parsedStatement.columns != null) {
                Connection connection = this.getConnection();
                StringBuffer sql = new StringBuffer(100);
                sql.append("select ");
                Iterator i = this.lobs.iterator();
                while (i.hasNext()) {
                    OracleHackedLob lob = (OracleHackedLob)i.next();
                    sql.append(lob.column.name);
                    if (!i.hasNext()) continue;
                    sql.append(",");
                }
                sql.append(" from ");
                sql.append(this.parsedStatement.table);
                StatementColumn column = this.parsedStatement.getIdColumn(connection);
                sql.append(" where ");
                sql.append(column.name);
                sql.append("=?");
                PreparedStatement ps = connection.prepareStatement(sql.toString());
                Object id = this.parsedStatement.getId();
                if (id instanceof Long) {
                    ps.setLong(1, (Long)id);
                } else if (id instanceof Integer) {
                    ps.setLong(1, ((Integer)id).intValue());
                } else if (id instanceof String) {
                    ps.setString(1, (String)id);
                }
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    int index = 1;
                    Iterator i2 = this.lobs.iterator();
                    while (i2.hasNext()) {
                        OracleHackedLob lob = (OracleHackedLob)i2.next();
                        if (lob.data instanceof Clob) {
                            CLOB clob = (CLOB)rs.getClob(index);
                            Writer writer = clob.getCharacterOutputStream();
                            Reader reader = ((Clob)lob.data).getCharacterStream();
                            FileUtil.copyFile(reader, writer);
                            reader.close();
                            writer.close();
                        } else if (lob.data instanceof Blob) {
                            BLOB blob = (BLOB)rs.getBlob(index);
                            OutputStream output = blob.getBinaryOutputStream();
                            InputStream input = ((Blob)lob.data).getBinaryStream();
                            FileUtil.copyFile(input, output);
                            input.close();
                            output.close();
                        }
                        ++index;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean temp = super.execute(sql, autoGeneratedKeys);
        this.executeLobHack();
        return temp;
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean temp = super.execute(sql, columnIndexes);
        this.executeLobHack();
        return temp;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean temp = super.execute(sql, columnNames);
        this.executeLobHack();
        return temp;
    }

    public boolean execute(String sql) throws SQLException {
        boolean temp = super.execute(sql);
        this.executeLobHack();
        return temp;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet temp = super.executeQuery(sql);
        this.executeLobHack();
        return temp;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int temp = super.executeUpdate(sql, autoGeneratedKeys);
        this.executeLobHack();
        return temp;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int temp = super.executeUpdate(sql, columnIndexes);
        this.executeLobHack();
        return temp;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int temp = super.executeUpdate(sql, columnNames);
        this.executeLobHack();
        return temp;
    }

    public int executeUpdate(String sql) throws SQLException {
        int temp = super.executeUpdate(sql);
        this.executeLobHack();
        return temp;
    }

    class OracleHackedLob {
        StatementColumn column;
        Object data;

        OracleHackedLob(StatementColumn column, Object data) {
            this.column = column;
            this.data = data;
        }
    }

    class StatementColumn {
        int position;
        String name;

        StatementColumn(int position, String name) {
            this.position = position;
            this.name = name;
        }
    }

    class ParsedStatement {
        String table;
        StatementColumn[] columns = null;
        StatementColumn idColumn = null;
        int leftIndex = 0;
        int rightIndex = 0;

        ParsedStatement(String sql) {
            this.parse(sql);
        }

        StatementColumn getIdColumn(Connection connection) throws SQLException {
            if (this.idColumn == null) {
                DatabaseMetaData md = connection.getMetaData();
                ResultSet pk = md.getPrimaryKeys(null, null, this.table.toUpperCase());
                String name = null;
                this.idColumn = null;
                if (pk.next()) {
                    name = pk.getString("COLUMN_NAME");
                    for (int i = 0; i < this.columns.length; ++i) {
                        if (!this.columns[i].name.toUpperCase().equals(name)) continue;
                        this.idColumn = this.columns[i];
                        break;
                    }
                }
                pk.close();
                if (name == null) {
                    throw new RuntimeException("no primary key for table " + this.table);
                }
                if (this.idColumn == null) {
                    throw new RuntimeException("could not find matching column for key " + name);
                }
            }
            return this.idColumn;
        }

        Object getId() {
            Integer key = new Integer(this.idColumn.position);
            return OracleHackedPreparedStatement.this.columnData.get(key);
        }

        private void parse(String sql) {
            this.skipWhitespace(sql);
            String op = this.getKeyword(sql).toUpperCase();
            if (op.equals("INSERT")) {
                this.parseInsert(sql);
            } else if (op.equals("UPDATE")) {
                this.parseUpdate(sql);
            }
        }

        private void skipWhitespace(String sql) {
            while (Character.isWhitespace(sql.charAt(this.rightIndex))) {
                ++this.rightIndex;
            }
            this.leftIndex = this.rightIndex;
        }

        private String getKeyword(String sql) {
            while (!Character.isWhitespace(sql.charAt(this.rightIndex))) {
                ++this.rightIndex;
            }
            return sql.substring(this.leftIndex, this.rightIndex);
        }

        private void parseInsert(String sql) {
            char ch;
            LinkedList<StatementColumn> columns = new LinkedList<StatementColumn>();
            this.skipWhitespace(sql);
            String into = this.getKeyword(sql).toUpperCase();
            if (!into.equals("INTO")) {
                throw new RuntimeException("not expecting " + into);
            }
            this.skipWhitespace(sql);
            this.table = this.getKeyword(sql);
            this.skipWhitespace(sql);
            if (sql.charAt(this.rightIndex) != '(') {
                throw new RuntimeException("expecting (");
            }
            ++this.rightIndex;
            this.leftIndex = this.rightIndex;
            ArrayList<String> columnNames = new ArrayList<String>();
            do {
                this.skipWhitespace(sql);
                ch = sql.charAt(this.rightIndex);
                while (ch != ',' && ch != ')') {
                    ++this.rightIndex;
                    ch = sql.charAt(this.rightIndex);
                }
                String columnName = sql.substring(this.leftIndex, this.rightIndex).trim();
                columnNames.add(columnName);
                this.leftIndex = ++this.rightIndex;
            } while (ch != ')');
            this.skipWhitespace(sql);
            String values = this.getKeyword(sql).toUpperCase();
            if (!values.equals("VALUES")) {
                throw new RuntimeException("not expecting " + values);
            }
            this.skipWhitespace(sql);
            if (sql.charAt(this.rightIndex) != '(') {
                throw new RuntimeException("expecting (");
            }
            ++this.rightIndex;
            this.leftIndex = this.rightIndex;
            int position = 1;
            int index = 0;
            while (true) {
                this.skipWhitespace(sql);
                char ch2 = sql.charAt(this.rightIndex);
                while (ch2 != ',' && ch2 != ')') {
                    ++this.rightIndex;
                    ch2 = sql.charAt(this.rightIndex);
                }
                String columnValue = sql.substring(this.leftIndex, this.rightIndex).trim();
                if (columnValue.equals("?")) {
                    columns.add(new StatementColumn(position, (String)columnNames.get(index)));
                    ++position;
                }
                this.leftIndex = ++this.rightIndex;
                if (ch2 == ')') break;
                ++index;
            }
            this.columns = new StatementColumn[columns.size()];
            columns.toArray(this.columns);
        }

        private void parseUpdate(String sql) {
            ArrayList<StatementColumn> columns = new ArrayList<StatementColumn>(10);
            this.skipWhitespace(sql);
            this.table = this.getKeyword(sql);
            int position = 1;
            this.skipWhitespace(sql);
            String set = this.getKeyword(sql).toUpperCase();
            if (!set.equals("SET")) {
                throw new RuntimeException("not expecting " + set);
            }
            boolean EXPECTING_COLUMN_NAME = false;
            boolean GOT_COLUMN_NAME = true;
            int GOT_EQUALS = 2;
            int GOT_COLUMN_VALUE = 3;
            int state = 0;
            int sqlLen = sql.length();
            String columnName = null;
            while (this.rightIndex < sqlLen) {
                this.skipWhitespace(sql);
                char ch = sql.charAt(this.rightIndex);
                while (ch != ',' && ch != '=' && !Character.isWhitespace(ch)) {
                    ++this.rightIndex;
                    if (this.rightIndex >= sqlLen) break;
                    ch = sql.charAt(this.rightIndex);
                }
                String next = sql.substring(this.leftIndex, this.rightIndex);
                this.leftIndex = ++this.rightIndex;
                if (state == 0) {
                    columnName = next;
                    state = ch == '=' ? 2 : 1;
                    if (ch != ',') continue;
                    throw new RuntimeException("not expecting , here");
                }
                if (state == 1) {
                    if (ch == '=') {
                        state = 2;
                        continue;
                    }
                    throw new RuntimeException("expecting =");
                }
                if (state == 2) {
                    if (next.equals("?")) {
                        columns.add(new StatementColumn(position, columnName));
                        ++position;
                    }
                    if (ch == ',') {
                        state = 0;
                        continue;
                    }
                    state = 3;
                    continue;
                }
                if (state != 3) continue;
                if (ch == ',') {
                    state = 0;
                    continue;
                }
                if (next.toUpperCase().equals("WHERE")) {
                    state = 0;
                    continue;
                }
                throw new RuntimeException("not expecting " + next);
            }
            this.columns = new StatementColumn[columns.size()];
            columns.toArray(this.columns);
        }
    }
}

