/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.oracle;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;

public class PreparedStatementWrapper
implements PreparedStatement {
    protected PreparedStatement ps;
    protected Map columnData = new TreeMap();

    public PreparedStatementWrapper(PreparedStatement ps) {
        this.ps = ps;
    }

    public PreparedStatement getWrappedPreparedStatement() {
        return this.ps;
    }

    public ResultSet executeQuery() throws SQLException {
        return this.ps.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return this.ps.executeUpdate();
    }

    public void setNull(int i, int sqlType) throws SQLException {
        this.ps.setNull(i, sqlType);
    }

    public void setBoolean(int i, boolean x) throws SQLException {
        this.ps.setBoolean(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public void setByte(int i, byte x) throws SQLException {
        this.ps.setByte(i, x);
        this.columnData.put(new Integer(i), new Byte(x));
    }

    public void setShort(int i, short x) throws SQLException {
        this.ps.setShort(i, x);
        this.columnData.put(new Integer(i), new Short(x));
    }

    public void setInt(int i, int x) throws SQLException {
        this.ps.setInt(i, x);
        this.columnData.put(new Integer(i), new Integer(x));
    }

    public void setLong(int i, long x) throws SQLException {
        this.ps.setLong(i, x);
        this.columnData.put(new Integer(i), new Long(x));
    }

    public void setFloat(int i, float x) throws SQLException {
        this.ps.setFloat(i, x);
        this.columnData.put(new Integer(i), new Float(x));
    }

    public void setDouble(int i, double x) throws SQLException {
        this.ps.setDouble(i, x);
        this.columnData.put(new Integer(i), new Double(x));
    }

    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        this.ps.setBigDecimal(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public void setString(int i, String x) throws SQLException {
        this.ps.setString(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public void setBytes(int i, byte[] x) throws SQLException {
        this.ps.setBytes(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public void setDate(int i, Date x) throws SQLException {
        this.ps.setDate(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public void setTime(int i, Time x) throws SQLException {
        this.ps.setTime(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public void setTimestamp(int i, Timestamp x) throws SQLException {
        this.ps.setTimestamp(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public void setAsciiStream(int i, InputStream x, int length) throws SQLException {
        this.ps.setAsciiStream(i, x, length);
    }

    public void setBinaryStream(int i, InputStream x, int length) throws SQLException {
        this.ps.setBinaryStream(i, x, length);
    }

    public void clearParameters() throws SQLException {
        this.ps.clearParameters();
    }

    public void setObject(int i, Object x, int targetSqlType, int scale) throws SQLException {
        this.ps.setObject(i, x, targetSqlType, scale);
        this.columnData.put(new Integer(i), x);
    }

    public void setObject(int i, Object x, int targetSqlType) throws SQLException {
        this.ps.setObject(i, x, targetSqlType);
        this.columnData.put(new Integer(i), x);
    }

    public void setObject(int i, Object x) throws SQLException {
        this.ps.setObject(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public boolean execute() throws SQLException {
        return this.ps.execute();
    }

    public void addBatch() throws SQLException {
        this.ps.addBatch();
    }

    public void setCharacterStream(int i, Reader reader, int length) throws SQLException {
        this.ps.setCharacterStream(i, reader, length);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.ps.setRef(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.ps.setBlob(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.ps.setClob(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.ps.setArray(i, x);
        this.columnData.put(new Integer(i), x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    public void setDate(int i, Date x, Calendar cal) throws SQLException {
        this.ps.setDate(i, x, cal);
        this.columnData.put(new Integer(i), x);
    }

    public void setTime(int i, Time x, Calendar cal) throws SQLException {
        this.ps.setTime(i, x, cal);
        this.columnData.put(new Integer(i), x);
    }

    public void setTimestamp(int i, Timestamp x, Calendar cal) throws SQLException {
        this.ps.setTimestamp(i, x, cal);
        this.columnData.put(new Integer(i), x);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.ps.setNull(paramIndex, sqlType, typeName);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.ps.executeQuery(sql);
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.ps.executeUpdate(sql);
    }

    public void close() throws SQLException {
        this.ps.close();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.ps.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.ps.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ps.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.ps.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.ps.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.ps.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.ps.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        return this.ps.execute(sql);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.ps.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.ps.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.ps.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.ps.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.ps.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this.ps.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.ps.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.ps.getConnection();
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.ps.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.ps.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ps.getGeneratedKeys();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.ps.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.ps.execute(sql, columnNames);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setUnicodeStream(parameterIndex, x, length);
    }
}

