/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.runner;

import com.subshell.persistence.exception.ErrorInRunnableException;
import com.subshell.persistence.exception.PersistenceException;
import com.subshell.persistence.runner.TransactionContextRunner;

final class SelfContainedTransactionContextRunnerThread
extends Thread {
    private Runnable runnable;
    private TransactionContextRunner runner;
    private ErrorInRunnableException errorInRunnableException = null;
    private PersistenceException persistenceException = null;

    SelfContainedTransactionContextRunnerThread(Runnable runnable, TransactionContextRunner runner) {
        super("self-contained transaction context runner");
        this.runnable = runnable;
        this.runner = runner;
    }

    public void run() {
        try {
            this.runner.run(this.runnable);
        }
        catch (ErrorInRunnableException e) {
            this.errorInRunnableException = e;
        }
        catch (PersistenceException e) {
            this.persistenceException = e;
        }
    }

    ErrorInRunnableException getErrorInRunnableException() {
        return this.errorInRunnableException;
    }

    PersistenceException getPersistenceException() {
        return this.persistenceException;
    }
}

