/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.ExtBuffer;
import com.sun.media.NBA;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;

public abstract class BasicPlugIn
implements PlugIn {
    private static final boolean DEBUG = false;
    protected Object[] controls = new Control[0];
    private static boolean jdkInit = false;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Thread;

    protected void error() {
        throw new RuntimeException(this.getClass().getName() + " PlugIn error");
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            int i2 = 0;
            while (i2 < cs.length) {
                if (cls.isInstance(cs[i2])) {
                    return cs[i2];
                }
                ++i2;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Format matches(Format in, Format[] outs) {
        int i2 = 0;
        while (i2 < outs.length) {
            if (in.matches(outs[i2])) {
                return outs[i2];
            }
            ++i2;
        }
        return null;
    }

    protected byte[] validateByteArraySize(Buffer buffer, int newSize) {
        byte[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof byte[]) {
            typedArray = (byte[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            byte[] tempArray = new byte[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new byte[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }

    protected short[] validateShortArraySize(Buffer buffer, int newSize) {
        short[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof short[]) {
            typedArray = (short[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            short[] tempArray = new short[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new short[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }

    protected int[] validateIntArraySize(Buffer buffer, int newSize) {
        int[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof int[]) {
            typedArray = (int[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            int[] tempArray = new int[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new int[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }

    protected long getNativeData(Object data) {
        if (data instanceof NBA) {
            return ((NBA)data).data;
        }
        return 0L;
    }

    protected Object getInputData(Buffer inBuffer) {
        Object inData = null;
        if (inBuffer instanceof ExtBuffer) {
            ((ExtBuffer)inBuffer).setNativePreferred(true);
            inData = ((ExtBuffer)inBuffer).getNativeData();
        }
        if (inData == null) {
            inData = inBuffer.getData();
        }
        return inData;
    }

    protected Object getOutputData(Buffer buffer) {
        Object data = null;
        if (buffer instanceof ExtBuffer) {
            data = ((ExtBuffer)buffer).getNativeData();
        }
        if (data == null) {
            data = buffer.getData();
        }
        return data;
    }

    protected Object validateData(Buffer buffer, int length, boolean allowNative) {
        Format format = buffer.getFormat();
        Class dataType = format.getDataType();
        if (length < 1 && format != null && format instanceof VideoFormat) {
            length = ((VideoFormat)format).getMaxDataLength();
        }
        if (allowNative && buffer instanceof ExtBuffer && ((ExtBuffer)buffer).isNativePreferred()) {
            ExtBuffer extb = (ExtBuffer)buffer;
            if (extb.getNativeData() == null || extb.getNativeData().size < length) {
                extb.setNativeData(new NBA(format.getDataType(), length));
            }
            return extb.getNativeData();
        }
        if (dataType == Format.byteArray) {
            return this.validateByteArraySize(buffer, length);
        }
        if (dataType == Format.shortArray) {
            return this.validateShortArraySize(buffer, length);
        }
        if (dataType == Format.intArray) {
            return this.validateIntArraySize(buffer, length);
        }
        System.err.println("Error in validateData");
        return null;
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class == null ? (class$java$lang$Class = BasicPlugIn.class$("java.lang.Class")) : class$java$lang$Class).getMethod("forName", class$java$lang$String == null ? (class$java$lang$String = BasicPlugIn.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = BasicPlugIn.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            getSystemClassLoaderM = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = BasicPlugIn.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = BasicPlugIn.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader), null);
            getContextClassLoaderM = (class$java$lang$Thread == null ? (class$java$lang$Thread = BasicPlugIn.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            return true;
        }
        catch (Throwable t) {
            forName3ArgsM = null;
            return false;
        }
    }

    public static Class getClassForName(String className) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(className);
            }
            catch (Exception e2) {
                if (!BasicPlugIn.checkIfJDK12()) {
                    throw new ClassNotFoundException(e2.getMessage());
                }
            }
            catch (Error e3) {
                if (BasicPlugIn.checkIfJDK12()) break block9;
                throw e3;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = BasicPlugIn.class$("java.lang.Class")) : class$java$lang$Class), className, new Boolean(true), systemClassLoader);
        }
        catch (Throwable e4) {
            try {
                ClassLoader contextClassLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = BasicPlugIn.class$("java.lang.Class")) : class$java$lang$Class), className, new Boolean(true), contextClassLoader);
            }
            catch (Exception e5) {
                throw new ClassNotFoundException(e5.getMessage());
            }
            catch (Error e6) {
                throw e6;
            }
        }
    }

    public static boolean plugInExists(String name, int type) {
        Vector cnames = PlugInManager.getPlugInList(null, null, type);
        int i2 = 0;
        while (i2 < cnames.size()) {
            if (name.equals((String)cnames.elementAt(i2))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public abstract void reset();

    public abstract void close();

    public abstract void open() throws ResourceUnavailableException;

    public abstract String getName();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

