/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer;

import com.sun.media.BasicClock;
import com.sun.media.multiplexer.RawBufferMux;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class RawSyncBufferMux
extends RawBufferMux {
    boolean mpegBFrame = false;
    boolean mpegPFrame = false;
    protected boolean monoIncrTime = false;
    private long monoStartTime = 0L;
    private long monoTime = 0L;
    private Object waitLock = new Object();
    private boolean resetted = false;
    private boolean masterTrackEnded = false;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    static int THRESHOLD = 80;
    static int LEEWAY = 5;

    public RawSyncBufferMux() {
        this.timeBase = new RawBufferMux.RawMuxTimeBase();
        this.allowDrop = true;
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean initializeTracks(Format[] trackFormats) {
        if (!super.initializeTracks(trackFormats)) {
            return false;
        }
        this.masterTrackID = 0;
        int i2 = 0;
        while (i2 < trackFormats.length) {
            if (trackFormats[i2] instanceof AudioFormat) {
                this.masterTrackID = i2;
            }
            ++i2;
        }
        return true;
    }

    public void reset() {
        super.reset();
        this.mpegBFrame = false;
        this.mpegPFrame = false;
        Object object = this.waitLock;
        synchronized (object) {
            this.resetted = true;
            this.waitLock.notify();
        }
    }

    public String getName() {
        return "Raw Sync Buffer Multiplexer";
    }

    public int process(Buffer buffer, int trackID) {
        if ((buffer.getFlags() & 0x1000) != 0) {
            buffer.setFlags(buffer.getFlags() & 0xFFFFEFFF | 0x100);
        }
        if (this.mc[trackID] != null && this.mc[trackID].isEnabled()) {
            this.mc[trackID].process(buffer);
        }
        if (this.streams == null || buffer == null || trackID >= this.streams.length) {
            return 1;
        }
        if (buffer.isDiscard()) {
            return 0;
        }
        if ((buffer.getFlags() & 0x40) == 0) {
            if (buffer.getFormat() instanceof AudioFormat) {
                if (mpegAudio.matches(buffer.getFormat())) {
                    this.waitForPT(buffer.getTimeStamp(), trackID);
                } else {
                    this.waitForPT(this.mediaTime[trackID], trackID);
                }
            } else if (buffer.getTimeStamp() >= 0L) {
                if (mpegVideo.matches(buffer.getFormat()) && (buffer.getFlags() & 0x800) != 0) {
                    int offset;
                    byte[] payload = (byte[])buffer.getData();
                    int ptype = payload[(offset = buffer.getOffset()) + 2] & 7;
                    if (ptype > 2) {
                        this.mpegBFrame = true;
                    } else if (ptype == 2) {
                        this.mpegPFrame = true;
                    }
                    if (ptype > 2 || ptype == 2 && !this.mpegBFrame || ptype == 1 && !(this.mpegBFrame | this.mpegPFrame)) {
                        this.waitForPT(buffer.getTimeStamp(), trackID);
                    }
                } else {
                    this.waitForPT(buffer.getTimeStamp(), trackID);
                }
            }
        }
        this.updateTime(buffer, trackID);
        buffer.setFlags(buffer.getFlags() | 0x60);
        if ((!(buffer.getFormat() instanceof AudioFormat) || mpegAudio.matches(buffer.getFormat())) && this.monoIncrTime) {
            this.monoTime = this.monoStartTime + buffer.getTimeStamp() - this.mediaStartTime * 1000000L;
            buffer.setTimeStamp(this.monoTime);
        }
        if (buffer.isEOM() && trackID == this.masterTrackID) {
            this.masterTrackEnded = true;
        }
        buffer.setHeader(new Long(System.currentTimeMillis()));
        return this.streams[trackID].process(buffer);
    }

    public void syncStart(Time at) {
        this.masterTrackEnded = false;
        super.syncStart(at);
    }

    public void setMediaTime(Time now) {
        super.setMediaTime(now);
        this.monoStartTime = this.monoTime + 10L;
    }

    protected void updateTime(Buffer buf, int trackID) {
        if (buf.getFormat() instanceof AudioFormat) {
            if (mpegAudio.matches(buf.getFormat())) {
                if (buf.getTimeStamp() < 0L) {
                    if (this.systemStartTime >= 0L) {
                        this.mediaTime[trackID] = (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L;
                    }
                } else {
                    this.mediaTime[trackID] = buf.getTimeStamp();
                }
            } else {
                long t = ((AudioFormat)buf.getFormat()).computeDuration(buf.getLength());
                if (t >= 0L) {
                    int n2 = trackID;
                    this.mediaTime[n2] = this.mediaTime[n2] + t;
                } else {
                    this.mediaTime[trackID] = buf.getTimeStamp();
                }
            }
        } else {
            this.mediaTime[trackID] = buf.getTimeStamp() < 0L && this.systemStartTime >= 0L ? (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L : buf.getTimeStamp();
        }
        this.timeBase.update();
    }

    /*
     * Unable to fully structure code
     */
    private void waitForPT(long pt, int trackID) {
        delay = this.masterTrackID == -1 || trackID == this.masterTrackID ? (this.systemStartTime < 0L ? 0L : pt - this.mediaStartTime - (System.currentTimeMillis() - this.systemStartTime)) : (pt /= 1000000L) - this.mediaTime[this.masterTrackID] / 1000000L;
        if (delay <= 2000L) ** GOTO lbl21
        return;
lbl-1000:
        // 1 sources

        {
            if (delay > (long)RawSyncBufferMux.THRESHOLD) {
                delay = RawSyncBufferMux.THRESHOLD;
            }
            var6_4 = this.waitLock;
            synchronized (var6_4) {
                try {
                    this.waitLock.wait(delay);
                }
                catch (Exception e) {
                    break;
                }
                if (this.resetted) {
                    this.resetted = false;
                    break;
                }
            }
            delay = this.masterTrackID == -1 || trackID == this.masterTrackID ? pt - this.mediaStartTime - (System.currentTimeMillis() - this.systemStartTime) : pt - this.mediaTime[this.masterTrackID] / 1000000L;
lbl21:
            // 2 sources

            ** while (delay > (long)RawSyncBufferMux.LEEWAY && !this.masterTrackEnded)
        }
lbl22:
        // 3 sources

    }
}

