/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Rect;
import java.awt.Point;

class Matrix {
    int a = 65536;
    int b = 0;
    int c = 0;
    int d = 65536;
    int tx = 0;
    int ty = 0;
    static final int one = 65536;
    static final int sqrt2 = 92682;
    private static final int[] lengthTable = new int[]{0x40000000, 1073872888, 1074265984, 1074920825, 1075836932, 1077013639, 1078450093, 1080145258, 1082097918, 1084306681, 1086769986, 1089486107, 1092453157, 1095669100, 1099131748, 1102838780, 1106787739, 1110976045, 1115401003, 1120059807, 1124949552, 1130067241, 1135409791, 1140974043, 1146756771, 1152754686, 1158964447, 1165382668, 1172005924, 1178830760, 1185853694, 1193071229, 1200479854, 1208076055, 1215856315, 1223817123, 1231954981, 1240266402, 1248747921, 1257396097, 1266207514, 1275178788, 1284306569, 1293587545, 1303018442, 1312596028, 1322317116, 1332178565, 0x50000000, 1352310217, 1362574382, 1372966831, 1383484673, 1394125071, 1404885240, 1415762448, 1426754019, 1437857331, 1449069814, 1460388955, 1471812291, 1483337417, 1494961978, 1506683672, 1518500250, 1518500250};

    Matrix() {
    }

    Matrix(Matrix m2) {
        this.a = m2.a;
        this.b = m2.b;
        this.c = m2.c;
        this.d = m2.d;
        this.tx = m2.tx;
        this.ty = m2.ty;
    }

    final void transform(Point p, Point dst) {
        int x = Matrix.mul(this.a, p.x) + this.tx;
        if (this.c != 0) {
            x += Matrix.mul(this.c, p.y);
        }
        int y = Matrix.mul(this.d, p.y) + this.ty;
        if (this.b != 0) {
            y += Matrix.mul(this.b, p.x);
        }
        dst.x = x;
        dst.y = y;
    }

    final void transform(Point p) {
        int x = Matrix.mul(this.a, p.x) + this.tx;
        if (this.c != 0) {
            x += Matrix.mul(this.c, p.y);
        }
        int y = Matrix.mul(this.d, p.y) + this.ty;
        if (this.b != 0) {
            y += Matrix.mul(this.b, p.x);
        }
        p.x = x;
        p.y = y;
    }

    final void scale(int sx, int sy) {
        this.a = sx;
        this.d = sy;
        this.c = 0;
        this.b = 0;
        this.ty = 0;
        this.tx = 0;
    }

    final void deltaTransform(Point p) {
        int x = Matrix.mul(this.a, p.x);
        if (this.c != 0) {
            x += Matrix.mul(this.c, p.y);
        }
        int y = Matrix.mul(this.d, p.y);
        if (this.b != 0) {
            y += Matrix.mul(this.b, p.x);
        }
        p.x = x;
        p.y = y;
    }

    final Rect transform(Rect src) {
        Rect dst = new Rect();
        if (!src.isEmpty()) {
            Point pt = new Point(src.xmin, src.ymin);
            Point dp = new Point(0, 0);
            this.transform(pt, dp);
            dst.union(dp);
            pt.x = src.xmax;
            this.transform(pt, dp);
            dst.union(dp);
            pt.y = src.ymax;
            this.transform(pt, dp);
            dst.union(dp);
            pt.x = src.xmin;
            this.transform(pt, dp);
            dst.union(dp);
        }
        return dst;
    }

    int transform(int t) {
        Point pt = new Point(t, t);
        this.deltaTransform(pt);
        int thick = Matrix.mul(46341, Matrix.length(pt.x, pt.y));
        if (t > 0) {
            thick = Math.max(1, thick);
        }
        return thick;
    }

    final Matrix invert() {
        Matrix m2 = new Matrix();
        if (this.b == 0 && this.c == 0) {
            m2.a = Matrix.div(65536, this.a);
            m2.d = Matrix.div(65536, this.d);
            m2.tx = -Matrix.mul(m2.a, this.tx);
            m2.ty = -Matrix.mul(m2.d, this.ty);
        } else {
            double a0 = (double)this.a * 1.52587890625E-5;
            double a3 = (double)this.d * 1.52587890625E-5;
            double a1 = (double)this.b * 1.52587890625E-5;
            double a2 = (double)this.c * 1.52587890625E-5;
            double det = a0 * a3 - a1 * a2;
            if (det != 0.0) {
                det = 1.0 / det;
                m2.a = (int)(a3 * det * 65536.0);
                m2.b = -((int)(a1 * det * 65536.0));
                m2.c = -((int)(a2 * det * 65536.0));
                m2.d = (int)(a0 * det * 65536.0);
                Point pt = new Point(this.tx, this.ty);
                m2.deltaTransform(pt);
                m2.tx = -pt.x;
                m2.ty = -pt.y;
            }
        }
        return m2;
    }

    static final Matrix concat(Matrix m1, Matrix m2) {
        Matrix m3 = new Matrix();
        m3.a = Matrix.mul(m1.a, m2.a);
        m3.d = Matrix.mul(m1.d, m2.d);
        m3.tx = Matrix.mul(m1.tx, m2.a) + m2.tx;
        m3.ty = Matrix.mul(m1.ty, m2.d) + m2.ty;
        if (m1.b != 0 || m1.c != 0 || m2.b != 0 || m2.c != 0) {
            m3.a += Matrix.mul(m1.b, m2.c);
            m3.d += Matrix.mul(m1.c, m2.b);
            m3.b += Matrix.mul(m1.a, m2.b) + Matrix.mul(m1.b, m2.d);
            m3.c += Matrix.mul(m1.c, m2.a) + Matrix.mul(m1.d, m2.c);
            m3.tx += Matrix.mul(m1.ty, m2.c);
            m3.ty += Matrix.mul(m1.tx, m2.b);
        }
        return m3;
    }

    static final int mul(int a2, int b2) {
        return (int)((long)a2 * (long)b2 + 32768L >> 16);
    }

    static final int div(int a2, int b2) {
        if (b2 != 0) {
            return (int)(((long)a2 << 16) / (long)b2);
        }
        return Integer.MAX_VALUE;
    }

    static final int abs(int x) {
        return x > 0 ? x : -x;
    }

    static final int fastLength(int x, int y) {
        int dx = Matrix.abs(x);
        int dy = Matrix.abs(y);
        return dx + dy - (Math.min(dx, dy) >> 1);
    }

    static final int length(int x, int y) {
        int maxC;
        int minC = Matrix.abs(x);
        if (minC > (maxC = Matrix.abs(y))) {
            int tmp = minC;
            minC = maxC;
            maxC = tmp;
        }
        if (maxC == 0) {
            return 0;
        }
        int slope = Matrix.div(minC, maxC);
        int index = slope >> 10;
        int ratio = (slope & 0x3FF) << 6;
        int ft = Matrix.mul(65536 - ratio, lengthTable[index]) + Matrix.mul(ratio, lengthTable[index + 1]);
        return Matrix.mul(maxC, ft >>= 14);
    }
}

