/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import java.awt.Point;

final class Rect {
    public int xmin;
    public int ymin;
    public int xmax;
    public int ymax;
    static final int rectEmptyFlag = Integer.MIN_VALUE;

    Rect() {
        this.ymax = Integer.MIN_VALUE;
        this.xmax = Integer.MIN_VALUE;
        this.ymin = Integer.MIN_VALUE;
        this.xmin = Integer.MIN_VALUE;
    }

    Rect(Rect r) {
        this.xmin = r.xmin;
        this.ymin = r.ymin;
        this.xmax = r.xmax;
        this.ymax = r.ymax;
    }

    Rect(int x1, int y1, int x2, int y2) {
        if (x1 < x2) {
            this.xmin = x1;
            this.xmax = x2;
        } else {
            this.xmin = x2;
            this.xmax = x1;
        }
        if (y1 < y2) {
            this.ymin = y1;
            this.ymax = y2;
        } else {
            this.ymin = y2;
            this.ymax = y1;
        }
    }

    final void setEmpty() {
        this.ymax = Integer.MIN_VALUE;
        this.ymin = Integer.MIN_VALUE;
        this.xmax = Integer.MIN_VALUE;
        this.xmin = Integer.MIN_VALUE;
    }

    final boolean isEmpty() {
        return this.xmin == Integer.MIN_VALUE;
    }

    final void offset(int dx, int dy) {
        if (!this.isEmpty()) {
            this.xmin += dx;
            this.xmax += dx;
            this.ymin += dy;
            this.ymax += dy;
        }
    }

    final void union(Rect r) {
        if (!r.isEmpty()) {
            if (this.isEmpty()) {
                this.xmin = r.xmin;
                this.xmax = r.xmax;
                this.ymin = r.ymin;
                this.ymax = r.ymax;
            } else {
                this.xmin = Math.min(this.xmin, r.xmin);
                this.xmax = Math.max(this.xmax, r.xmax);
                this.ymin = Math.min(this.ymin, r.ymin);
                this.ymax = Math.max(this.ymax, r.ymax);
            }
        }
    }

    final void union(Point pt) {
        if (this.isEmpty()) {
            this.xmin = this.xmax = pt.x;
            this.ymin = this.ymax = pt.y;
        } else {
            if (pt.x < this.xmin) {
                this.xmin = pt.x;
            } else if (pt.x > this.xmax) {
                this.xmax = pt.x;
            }
            if (pt.y < this.ymin) {
                this.ymin = pt.y;
            } else if (pt.y > this.ymax) {
                this.ymax = pt.y;
            }
        }
    }

    final boolean testIntersect(Rect r2) {
        return this.xmin <= r2.xmax && r2.xmin <= this.xmax && this.ymin <= r2.ymax && r2.ymin <= this.ymax;
    }

    final boolean pointIn(Point pt) {
        return this.xmin <= pt.x && pt.x <= this.xmax && this.ymin <= pt.y && pt.y <= this.ymax;
    }
}

