/*
 * Decompiled with CFR 0.152.
 */
package org.opends.messages;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.opends.messages.Message;
import org.opends.messages.MessageDescriptor;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class MessageBuilder
implements Appendable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -3292823563904285315L;
    private final StringBuilder sb = new StringBuilder();
    private final List<Message> messages = new LinkedList<Message>();
    private final Locale locale;

    public MessageBuilder() {
        this(Locale.getDefault());
    }

    public MessageBuilder(Message message) {
        this(Locale.getDefault());
        this.append(message);
    }

    public MessageBuilder(String message) {
        this(Locale.getDefault());
        this.append(message);
    }

    public MessageBuilder(MessageBuilder mb) {
        for (Message msg : mb.messages) {
            this.messages.add(msg);
        }
        this.sb.append((CharSequence)this.sb);
        this.locale = mb.locale;
    }

    public MessageBuilder(Locale locale) {
        this.locale = locale;
    }

    public MessageBuilder append(Message message) {
        if (message != null) {
            this.sb.append(message.toString(this.locale));
            this.messages.add(message);
        }
        return this;
    }

    public MessageBuilder append(int number) {
        this.append(String.valueOf(number));
        return this;
    }

    public MessageBuilder append(Object object) {
        if (object != null) {
            this.append(String.valueOf(object));
        }
        return this;
    }

    public MessageBuilder append(CharSequence cs) {
        if (cs != null) {
            this.sb.append(cs);
            if (cs instanceof Message) {
                this.messages.add((Message)cs);
            } else {
                this.messages.add(Message.raw(cs, new Object[0]));
            }
        }
        return this;
    }

    public MessageBuilder append(CharSequence csq, int start, int end) throws IndexOutOfBoundsException {
        return this.append(csq.subSequence(start, end));
    }

    public MessageBuilder append(char c) {
        return this.append(String.valueOf(c));
    }

    public String toString() {
        return this.sb.toString();
    }

    public String toString(Locale locale) {
        StringBuilder sb = new StringBuilder();
        for (Message m : this.messages) {
            sb.append(m.toString(locale));
        }
        return sb.toString();
    }

    public Message toMessage() {
        StringBuffer fmtString = new StringBuffer();
        for (int i = 0; i < this.messages.size(); ++i) {
            fmtString.append("%s");
        }
        if (this.messages.isEmpty()) {
            return Message.raw(fmtString, this.messages.toArray());
        }
        MessageDescriptor md = this.messages.get(0).getDescriptor();
        return Message.raw(md.getCategory(), md.getSeverity(), fmtString, this.messages.toArray());
    }

    public int length() {
        return this.length(Locale.getDefault());
    }

    public char charAt(int index) throws IndexOutOfBoundsException {
        return this.charAt(Locale.getDefault(), index);
    }

    public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        return this.subSequence(Locale.getDefault(), start, end);
    }

    public int length(Locale locale) {
        return this.toString(locale).length();
    }

    public char charAt(Locale locale, int index) throws IndexOutOfBoundsException {
        return this.toString(locale).charAt(index);
    }

    public CharSequence subSequence(Locale locale, int start, int end) throws IndexOutOfBoundsException {
        return this.toString(locale).subSequence(start, end);
    }
}

