/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.event.WindowEvent;
import java.security.cert.X509Certificate;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.CliUserInteraction;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.WizardStep;
import org.opends.quicksetup.ui.FramePanel;
import org.opends.quicksetup.ui.GuiUserInteraction;
import org.opends.quicksetup.ui.QuickSetup;
import org.opends.quicksetup.ui.QuickSetupDialog;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.util.InProcessServerController;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.UIKeyStore;
import org.opends.quicksetup.util.Utils;
import org.opends.quicksetup.webstart.WebStartDownloader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GuiApplication
extends Application {
    private static final Logger LOG = Logger.getLogger(GuiApplication.class.getName());
    private WizardStep displayedStep = this.getFirstWizardStep();
    protected WebStartDownloader loader;
    private QuickSetupDialog qs;

    public abstract Message getFrameTitle();

    public abstract WizardStep getFirstWizardStep();

    public void setDisplayedWizardStep(WizardStep step, UserData userData, QuickSetupDialog dlg) {
        this.displayedStep = step;
        dlg.setDisplayedStep(step, userData);
        this.setWizardDialogState(dlg, userData, step);
    }

    public abstract void setWizardDialogState(QuickSetupDialog var1, UserData var2, WizardStep var3);

    protected Message getTab() {
        return this.formatter.getTab();
    }

    public abstract void windowClosing(QuickSetupDialog var1, WindowEvent var2);

    public void forceToDisplay() {
    }

    public boolean confirmCancel(QuickSetup qs) {
        return qs.displayConfirmation(QuickSetupMessages.INFO_CONFIRM_CANCEL_PROMPT.get(), QuickSetupMessages.INFO_CONFIRM_CANCEL_TITLE.get());
    }

    public abstract ButtonName getInitialFocusButtonName();

    public JPanel createFramePanel(QuickSetupDialog dlg) {
        return new FramePanel(dlg.getStepsPanel(), dlg.getCurrentStepPanel(), dlg.getButtonsPanel());
    }

    public abstract Set<? extends WizardStep> getWizardSteps();

    public abstract QuickSetupStepPanel createWizardStepPanel(WizardStep var1);

    public abstract WizardStep getNextWizardStep(WizardStep var1);

    public abstract WizardStep getPreviousWizardStep(WizardStep var1);

    public abstract WizardStep getFinishedStep();

    public WizardStep getCurrentWizardStep() {
        return this.displayedStep;
    }

    protected QuickSetupDialog getQuickSetupDialog() {
        return this.qs;
    }

    public boolean isSubStep(WizardStep step) {
        return false;
    }

    public boolean isVisible(WizardStep step, UserData userData) {
        return true;
    }

    public boolean isVisible(WizardStep step, QuickSetup qs) {
        return true;
    }

    public LinkedHashSet<WizardStep> getOrderedSteps() {
        LinkedHashSet<WizardStep> orderedSteps = new LinkedHashSet<WizardStep>();
        WizardStep step = this.getFirstWizardStep();
        orderedSteps.add(step);
        while (null != (step = this.getNextWizardStep(step))) {
            orderedSteps.add(step);
        }
        return orderedSteps;
    }

    public boolean canGoBack(WizardStep step) {
        return !this.getFirstWizardStep().equals(step);
    }

    public boolean canGoForward(WizardStep step) {
        return !step.isProgressStep() && this.getNextWizardStep(step) != null;
    }

    public abstract boolean canFinish(WizardStep var1);

    public boolean canQuit(WizardStep step) {
        return false;
    }

    public abstract void previousClicked(WizardStep var1, QuickSetup var2);

    public abstract boolean finishClicked(WizardStep var1, QuickSetup var2);

    public abstract void nextClicked(WizardStep var1, QuickSetup var2);

    public void closeClicked(WizardStep cStep, QuickSetup qs) {
        qs.quit();
    }

    public void quitClicked(WizardStep step, QuickSetup qs) {
        qs.quit();
    }

    public abstract void updateUserData(WizardStep var1, QuickSetup var2) throws UserDataException;

    public Message getCloseButtonToolTip() {
        return QuickSetupMessages.INFO_CLOSE_BUTTON_TOOLTIP.get();
    }

    public Message getQuitButtonToolTip() {
        return QuickSetupMessages.INFO_QUIT_BUTTON_INSTALL_TOOLTIP.get();
    }

    public Message getFinishButtonToolTip() {
        return QuickSetupMessages.INFO_FINISH_BUTTON_TOOLTIP.get();
    }

    public Message getFinishButtonLabel() {
        return QuickSetupMessages.INFO_FINISH_BUTTON_LABEL.get();
    }

    public boolean finishOnLeft() {
        return true;
    }

    protected void acceptCertificateForException(UserDataCertificateException ce, boolean acceptPermanently) {
        X509Certificate[] chain = ce.getChain();
        String authType = ce.getAuthType();
        String host = ce.getHost();
        if (chain != null && authType != null && host != null) {
            LOG.log(Level.INFO, "Accepting certificate presented by host " + host);
            this.getTrustManager().acceptCertificate(chain, authType, host);
        } else {
            if (chain == null) {
                LOG.log(Level.WARNING, "The chain is null for the UserDataCertificateException");
            }
            if (authType == null) {
                LOG.log(Level.WARNING, "The auth type is null for the UserDataCertificateException");
            }
            if (host == null) {
                LOG.log(Level.WARNING, "The host is null for the UserDataCertificateException");
            }
        }
        if (acceptPermanently && chain != null) {
            try {
                UIKeyStore.acceptCertificate(chain);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error accepting certificate: " + t, t);
            }
        }
    }

    protected void initLoader() {
        this.loader = new WebStartDownloader();
        this.loader.start(false);
    }

    protected void waitForLoader(Integer maxRatio) throws ApplicationException {
        int lastPercentage = -1;
        WebStartDownloader.Status lastStatus = WebStartDownloader.Status.DOWNLOADING;
        while (!this.loader.isFinished() && this.loader.getException() == null) {
            this.checkAbort();
            int perc = this.loader.getDownloadPercentage();
            WebStartDownloader.Status downloadStatus = this.loader.getStatus();
            if (perc != lastPercentage || downloadStatus != lastStatus) {
                Message summary;
                lastPercentage = perc;
                int ratio = perc * maxRatio / 100;
                switch (downloadStatus) {
                    case VALIDATING: {
                        summary = QuickSetupMessages.INFO_VALIDATING_RATIO.get(String.valueOf(perc), String.valueOf(this.loader.getCurrentValidatingPercentage()));
                        break;
                    }
                    case UPGRADING: {
                        summary = QuickSetupMessages.INFO_UPGRADING_RATIO.get(String.valueOf(perc), String.valueOf(this.loader.getCurrentUpgradingPercentage()));
                        break;
                    }
                    default: {
                        summary = QuickSetupMessages.INFO_DOWNLOADING_RATIO.get(String.valueOf(perc));
                    }
                }
                this.loader.setSummary(summary);
                this.notifyListeners(ratio, summary, null);
            }
            this.checkAbort();
            try {
                Thread.sleep(300L);
            }
            catch (Exception ex) {}
        }
        this.checkAbort();
        if (this.loader.getException() != null) {
            throw this.loader.getException();
        }
    }

    public int getExtraDialogHeight() {
        return 0;
    }

    protected void startServerWithoutConnectionHandlers() throws ApplicationException {
        try {
            ServerController control = new ServerController(this.getInstallation());
            if (this.getInstallation().getStatus().isServerRunning()) {
                control.stopServer(true);
            }
            InProcessServerController ipsc = new InProcessServerController(this.getInstallation());
            InProcessServerController.disableConnectionHandlers(true);
            ipsc.startServer();
        }
        catch (Throwable t) {
            Message msg = QuickSetupMessages.INFO_ERROR_STARTING_SERVER_WITH_NO_CONNECTION_HANDLERS.get(t.getMessage() == null ? t.toString() : t.getMessage());
            LOG.log(Level.INFO, msg.toString(), t);
            throw new ApplicationException(ReturnCode.IMPORT_ERROR, msg, t);
        }
    }

    @Override
    public UserInteraction userInteraction() {
        UserInteraction ui = null;
        if (this.getUserData().isInteractive()) {
            ui = Utils.isCli() ? new CliUserInteraction() : new GuiUserInteraction(this.qs.getFrame());
        }
        return ui;
    }

    public void setQuickSetupDialog(QuickSetupDialog dialog) {
        this.qs = dialog;
    }
}

