/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.util.ExternalTools;
import org.opends.quicksetup.util.FileManager;
import org.opends.quicksetup.util.InProcessServerController;
import org.opends.quicksetup.util.OperationOutput;
import org.opends.quicksetup.util.Utils;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.LDIFReader;

public class MigrationManager {
    private static final Logger LOG = Logger.getLogger(MigrationManager.class.getName());
    private Installation installation;
    private File backupDir;
    private UserInteraction ui;
    private boolean isSchemaCustomized;

    public MigrationManager(Installation installation, File backupDir, UserInteraction ui) {
        if (installation == null) {
            throw new NullPointerException("installation cannot be null");
        }
        if (backupDir == null) {
            throw new NullPointerException("backup directory cannot be null");
        }
        this.installation = installation;
        this.backupDir = backupDir;
        this.ui = ui;
    }

    public void calculateSchemaCustomizations() throws ApplicationException {
        this.isSchemaCustomized = false;
        if (this.installation.getStatus().schemaHasBeenModified()) {
            LOG.log(Level.INFO, "Schema contains customizations that will be migrated");
            try {
                this.ldifDiff(this.installation.getBaseSchemaFile(), this.installation.getSchemaConcatFile(), this.getCustomSchemaDiffFile(), true);
                this.isSchemaCustomized = true;
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw ApplicationException.createFileSystemException(QuickSetupMessages.INFO_ERROR_DETERMINING_CUSTOM_SCHEMA.get(), e);
            }
        } else {
            LOG.log(Level.INFO, "No schema customizations to migrate");
        }
    }

    public void calculateConfigCustomizations() throws ApplicationException {
        block6: {
            try {
                if (this.installation.getCurrentConfiguration().hasBeenModified()) {
                    LOG.log(Level.INFO, "Configuration contains customizations that will be migrated");
                    try {
                        this.ldifDiff(this.installation.getBaseConfigurationFile(), this.installation.getCurrentConfigurationFile(), this.getCustomConfigDiffFile(), false);
                        break block6;
                    }
                    catch (ApplicationException ae) {
                        throw ae;
                    }
                    catch (Exception e) {
                        throw ApplicationException.createFileSystemException(QuickSetupMessages.INFO_ERROR_DETERMINING_CUSTOM_CONFIG.get(), e);
                    }
                }
                LOG.log(Level.INFO, "No configuration customizations to migrate");
            }
            catch (IOException e) {
                throw ApplicationException.createFileSystemException(QuickSetupMessages.INFO_ERROR_DETERMINING_CUSTOM_CONFIG.get(), e);
            }
        }
    }

    public void migrateConfiguration() throws ApplicationException {
        try {
            File configDiff = this.getCustomConfigDiffFile();
            if (configDiff.exists()) {
                this.modify(configDiff, Component.CONFIGURATION);
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Message msg = QuickSetupMessages.INFO_ERROR_APPLYING_CUSTOM_CONFIG.get();
            LOG.log(Level.INFO, msg.toString(), e);
            throw new ApplicationException(ReturnCode.IMPORT_ERROR, msg, e);
        }
    }

    public boolean mustMigrateADS() throws IOException {
        return !this.installation.getADSBackendFile().exists();
    }

    public void migrateADS(File newADSFile) throws ApplicationException {
        FileManager fileManager = new FileManager();
        fileManager.copy(newADSFile, this.installation.getConfigurationDirectory(), true);
    }

    public boolean mustMigrateToolProperties() {
        return !this.installation.getToolsPropertiesFile().exists();
    }

    public void migrateToolPropertiesFile(File newPropertiesFile) throws ApplicationException {
        FileManager fileManager = new FileManager();
        fileManager.copy(newPropertiesFile, this.installation.getConfigurationDirectory(), true);
    }

    public void migrateSchema() throws ApplicationException {
        try {
            File schemaDiff = this.getCustomSchemaDiffFile();
            if (schemaDiff.exists()) {
                this.modify(schemaDiff, Component.SCHEMA);
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Message msg = QuickSetupMessages.INFO_ERROR_APPLYING_CUSTOM_SCHEMA.get();
            LOG.log(Level.INFO, msg.toString(), e);
            throw new ApplicationException(ReturnCode.IMPORT_ERROR, msg, e);
        }
    }

    public boolean isSchemaCustomized() {
        return this.isSchemaCustomized;
    }

    public boolean isConfigurationCustomized() throws IOException {
        return this.installation.getCurrentConfiguration().hasBeenModified();
    }

    private void modify(File ldifFile, Component component) throws Exception {
        InProcessServerController ipsc = new InProcessServerController(this.installation);
        LDIFImportConfig importCfg = new LDIFImportConfig(Utils.getPath(ldifFile));
        LDIFReader ldifReader = new LDIFReader(importCfg);
        ArrayList<ChangeRecordEntry> remainingChanges = new ArrayList<ChangeRecordEntry>();
        ChangeRecordEntry o = ldifReader.readChangeRecord(false);
        while (o != null) {
            remainingChanges.add(o);
            o = ldifReader.readChangeRecord(false);
        }
        ArrayList<ChangeRecordEntry> appliedChanges = new ArrayList<ChangeRecordEntry>();
        while (remainingChanges.size() > 0) {
            Exception firstException = null;
            appliedChanges.clear();
            for (ChangeRecordEntry cre : remainingChanges) {
                try {
                    ipsc.modify(cre);
                    appliedChanges.add(cre);
                }
                catch (Exception e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            remainingChanges.removeAll(appliedChanges);
            if (firstException == null || appliedChanges.size() != 0) continue;
            if (this.ui != null) {
                Message cancel = QuickSetupMessages.INFO_CANCEL_BUTTON_LABEL.get();
                Message cont = QuickSetupMessages.INFO_CONTINUE_BUTTON_LABEL.get();
                Message retry = QuickSetupMessages.INFO_RETRY_BUTTON_LABEL.get();
                Object r = this.ui.confirm(this.getModificationErrorSummary(component), this.getModificationErrorMessage((ChangeRecordEntry)remainingChanges.get(0)), Message.raw(firstException.getLocalizedMessage(), new Object[0]), QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION.get(), UserInteraction.MessageType.ERROR, new Message[]{cancel, cont, retry}, cancel, null);
                if (cont.equals(r)) {
                    remainingChanges.remove(0);
                    continue;
                }
                if (retry.equals(r)) continue;
                throw new ApplicationException(ReturnCode.CANCELLED, QuickSetupMessages.INFO_UPGRADE_CANCELED.get(), firstException);
            }
            throw firstException;
        }
    }

    private Message getModificationErrorSummary(Component c) {
        Message summary;
        switch (c) {
            case SCHEMA: {
                summary = QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_SCHEMA.get();
                break;
            }
            case CONFIGURATION: {
                summary = QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_CONFIG.get();
                break;
            }
            default: {
                summary = Message.EMPTY;
            }
        }
        return summary;
    }

    private Message getModificationErrorMessage(ChangeRecordEntry cre) {
        MessageBuilder msg = new MessageBuilder();
        if (Utils.isCli()) {
            msg.append(Constants.LINE_SEPARATOR);
        } else {
            msg.append("<br>");
        }
        if (cre != null) {
            switch (cre.getChangeOperationType()) {
                case MODIFY: {
                    if (Utils.isCli()) {
                        msg.append(QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_MODIFY_CLI.get(cre.getDN().toNormalizedString()));
                        break;
                    }
                    msg.append(QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_MODIFY.get(cre.getDN().toNormalizedString()));
                    break;
                }
                case ADD: {
                    if (Utils.isCli()) {
                        msg.append(QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_ADD_CLI.get(cre.getDN().toNormalizedString()));
                        break;
                    }
                    msg.append(QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_ADD.get(cre.getDN().toNormalizedString()));
                    break;
                }
                case DELETE: {
                    if (Utils.isCli()) {
                        msg.append(QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_DELETE_CLI.get(cre.getDN().toNormalizedString()));
                        break;
                    }
                    msg.append(QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_DELETE.get(cre.getDN().toNormalizedString()));
                    break;
                }
                default: {
                    LOG.log(Level.INFO, "Unexpected change operation type " + (Object)((Object)cre.getChangeOperationType()));
                    if (Utils.isCli()) {
                        msg.append(QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_UNEXPECTED_CLI.get(cre.getDN().toNormalizedString()));
                        break;
                    }
                    msg.append(QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_UNEXPECTED.get(cre.getDN().toNormalizedString()));
                }
            }
        }
        if (Utils.isCli()) {
            msg.append(Constants.LINE_SEPARATOR);
            msg.append(Constants.LINE_SEPARATOR);
            msg.append(QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_NOTE_CLI.get(Utils.getPath(this.backupDir)));
        } else {
            msg.append("<br>");
            msg.append("<br>");
            msg.append(QuickSetupMessages.INFO_ERROR_UPGRADE_MIGRATION_NOTE.get(Utils.getPath(this.backupDir)));
        }
        return msg.toMessage();
    }

    private void ldifDiff(File source, File target, File output, boolean splitMods) throws ApplicationException, IOException, InterruptedException {
        ExternalTools et = new ExternalTools(this.installation);
        String[] args = splitMods ? new String[]{"-o", Utils.getPath(output), "-O", "-S"} : new String[]{"-o", Utils.getPath(output), "-O"};
        OperationOutput oo = et.ldifDiff(source, target, args);
        int ret = oo.getReturnCode();
        if (ret != 0) {
            throw new ApplicationException(ReturnCode.TOOL_ERROR, QuickSetupMessages.INFO_ERROR_LDIF_DIFF_TOOL_RETURN_CODE.get(Integer.toString(ret)), null);
        }
    }

    private File getCustomConfigDiffFile() throws IOException {
        return new File(this.backupDir, "config.custom.diff");
    }

    private File getCustomSchemaDiffFile() throws IOException {
        return new File(this.backupDir, "schema.custom.diff");
    }

    private File getCustomADSDiffFile() throws IOException {
        return new File(this.backupDir, "admin-backend.custom.diff");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Component {
        SCHEMA,
        CONFIGURATION;

    }
}

