/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import org.opends.quicksetup.upgrader.Upgrader;
import org.opends.quicksetup.util.Utils;

class UpgradeFileFilter
implements FileFilter {
    Set<File> filesToIgnore = new HashSet<File>();

    public UpgradeFileFilter(File root) {
        for (String rootFileNamesToIgnore : Upgrader.ROOT_FILES_TO_IGNORE_DURING_BACKUP) {
            this.filesToIgnore.add(new File(root, rootFileNamesToIgnore));
        }
        for (String rootFileNamesToIgnore : Upgrader.FILES_TO_IGNORE_DURING_BACKUP) {
            this.filesToIgnore.add(new File(root, rootFileNamesToIgnore));
        }
    }

    public boolean accept(File file) {
        boolean accept = true;
        for (File ignoreFile : this.filesToIgnore) {
            if (!ignoreFile.equals(file) && !Utils.isParentOf(ignoreFile, file)) continue;
            accept = false;
            break;
        }
        return accept;
    }
}

