/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.util.HashMap;
import org.opends.admin.ads.ADSContextException;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DsFrameworkCliReturnCode {
    SUCCESSFUL(0, AdminMessages.INFO_ADMIN_SUCCESSFUL.get()),
    SUCCESSFUL_NOP(SUCCESSFUL.getReturnCode(), AdminMessages.INFO_ADMIN_SUCCESSFUL_NOP.get()),
    CANNOT_INITIALIZE_ARGS(1, AdminMessages.ERR_ADMIN_NO_MESSAGE.get()),
    ERROR_PARSING_ARGS(2, AdminMessages.ERR_ADMIN_NO_MESSAGE.get()),
    CANNOT_CONNECT_TO_ADS(3, AdminMessages.ERR_ADMIN_NO_MESSAGE.get()),
    MISSING_HOSTNAME(4, AdminMessages.ERR_ADMIN_MISSING_HOSTNAME.get()),
    NOVALID_HOSTNAME(5, AdminMessages.ERR_ADMIN_NOVALID_HOSTNAME.get()),
    MISSING_IPATH(6, AdminMessages.ERR_ADMIN_MISSING_IPATH.get()),
    NOVALID_IPATH(7, AdminMessages.ERR_ADMIN_NOVALID_IPATH.get()),
    ACCESS_PERMISSION(8, AdminMessages.ERR_ADMIN_ACCESS_PERMISSION.get()),
    ALREADY_REGISTERED(9, AdminMessages.ERR_ADMIN_ALREADY_REGISTERED.get()),
    BROKEN_INSTALL(10, AdminMessages.ERR_ADMIN_BROKEN_INSTALL.get()),
    NOT_YET_REGISTERED(11, AdminMessages.ERR_ADMIN_NOT_YET_REGISTERED.get()),
    MISSING_PORT(12, AdminMessages.ERR_ADMIN_MISSING_PORT.get()),
    NOVALID_PORT(13, AdminMessages.ERR_ADMIN_NOVALID_PORT.get()),
    MISSING_NAME(14, AdminMessages.ERR_ADMIN_MISSING_NAME.get()),
    MISSING_ADMIN_UID(15, AdminMessages.ERR_ADMIN_MISSING_ADMIN_UID.get()),
    MISSING_ADMIN_PASSWORD(16, AdminMessages.ERR_ADMIN_MISSING_ADMIN_PASSWORD.get()),
    ERROR_UNEXPECTED(17, AdminMessages.ERR_ADMIN_ERROR_UNEXPECTED.get()),
    CONFLICTING_ARGS(18, AdminMessages.ERR_ADMIN_NO_MESSAGE.get()),
    SERVER_NOT_REGISTERED(19, AdminMessages.ERR_ADMIN_SERVER_NOT_REGISTERED.get());

    private final int returnCode;
    private final Message message;
    private static boolean initialized;
    private static HashMap<ADSContextException.ErrorType, DsFrameworkCliReturnCode> adsErrorToReturnCode;

    private DsFrameworkCliReturnCode(int returnCode, Message message) {
        this.returnCode = returnCode;
        this.message = message;
    }

    public Message getMessage() {
        return this.message;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    private static void registerAdsError() {
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_HOSTNAME, MISSING_HOSTNAME);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.NOVALID_HOSTNAME, NOVALID_HOSTNAME);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_IPATH, MISSING_IPATH);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.NOVALID_IPATH, NOVALID_IPATH);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.ACCESS_PERMISSION, ACCESS_PERMISSION);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.ALREADY_REGISTERED, ALREADY_REGISTERED);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.BROKEN_INSTALL, BROKEN_INSTALL);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.UNEXPECTED_ADS_BACKEND_TYPE, BROKEN_INSTALL);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.NOT_YET_REGISTERED, NOT_YET_REGISTERED);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_PORT, MISSING_PORT);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.NOVALID_PORT, NOVALID_PORT);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_NAME, MISSING_NAME);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_ADMIN_UID, MISSING_ADMIN_UID);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_ADMIN_PASSWORD, MISSING_ADMIN_PASSWORD);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.ERROR_UNEXPECTED, ERROR_UNEXPECTED);
    }

    public static DsFrameworkCliReturnCode getReturncodeFromAdsError(ADSContextException.ErrorType error) {
        if (!initialized) {
            DsFrameworkCliReturnCode.registerAdsError();
            initialized = true;
        }
        return adsErrorToReturnCode.get((Object)error);
    }

    static {
        initialized = false;
        adsErrorToReturnCode = new HashMap();
    }
}

