/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.LocalDBIndexCfgClient;
import org.opends.server.admin.std.meta.LocalDBBackendCfgDefn;
import org.opends.server.admin.std.server.LocalDBIndexCfg;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalDBIndexCfgDefn
extends ManagedObjectDefinition<LocalDBIndexCfgClient, LocalDBIndexCfg> {
    private static final LocalDBIndexCfgDefn INSTANCE = new LocalDBIndexCfgDefn();
    private static final AttributeTypePropertyDefinition PD_ATTRIBUTE;
    private static final IntegerPropertyDefinition PD_INDEX_ENTRY_LIMIT;
    private static final EnumPropertyDefinition<IndexType> PD_INDEX_TYPE;
    private static final IntegerPropertyDefinition PD_SUBSTRING_LENGTH;

    public static LocalDBIndexCfgDefn getInstance() {
        return INSTANCE;
    }

    private LocalDBIndexCfgDefn() {
        super("local-db-index", TopCfgDefn.getInstance());
    }

    @Override
    public LocalDBIndexCfgClient createClientConfiguration(ManagedObject<? extends LocalDBIndexCfgClient> impl) {
        return new LocalDBIndexCfgClientImpl(impl);
    }

    @Override
    public LocalDBIndexCfg createServerConfiguration(ServerManagedObject<? extends LocalDBIndexCfg> impl) {
        return new LocalDBIndexCfgServerImpl(impl);
    }

    @Override
    public Class<LocalDBIndexCfg> getServerConfigurationClass() {
        return LocalDBIndexCfg.class;
    }

    public AttributeTypePropertyDefinition getAttributePropertyDefinition() {
        return PD_ATTRIBUTE;
    }

    public IntegerPropertyDefinition getIndexEntryLimitPropertyDefinition() {
        return PD_INDEX_ENTRY_LIMIT;
    }

    public EnumPropertyDefinition<IndexType> getIndexTypePropertyDefinition() {
        return PD_INDEX_TYPE;
    }

    public IntegerPropertyDefinition getSubstringLengthPropertyDefinition() {
        return PD_SUBSTRING_LENGTH;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AttributeTypePropertyDefinition.createBuilder(INSTANCE, "attribute");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "attribute"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ATTRIBUTE = (AttributeTypePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ATTRIBUTE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "index-entry-limit");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "index-entry-limit"));
        DefaultBehaviorProvider provider = new RelativeInheritedDefaultBehaviorProvider(LocalDBBackendCfgDefn.getInstance(), "index-entry-limit", 1);
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_INDEX_ENTRY_LIMIT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_ENTRY_LIMIT);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "index-type");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "index-type"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(IndexType.class);
        PD_INDEX_TYPE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_TYPE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "substring-length");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "substring-length"));
        provider = new DefinedDefaultBehaviorProvider("6");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(3);
        PD_SUBSTRING_LENGTH = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SUBSTRING_LENGTH);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalDBIndexCfgServerImpl
    implements LocalDBIndexCfg {
        private ServerManagedObject<? extends LocalDBIndexCfg> impl;
        private final AttributeType pAttribute;
        private final Integer pIndexEntryLimit;
        private final SortedSet<IndexType> pIndexType;
        private final int pSubstringLength;

        private LocalDBIndexCfgServerImpl(ServerManagedObject<? extends LocalDBIndexCfg> impl) {
            this.impl = impl;
            this.pAttribute = impl.getPropertyValue(INSTANCE.getAttributePropertyDefinition());
            this.pIndexEntryLimit = impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
            this.pIndexType = impl.getPropertyValues(INSTANCE.getIndexTypePropertyDefinition());
            this.pSubstringLength = impl.getPropertyValue(INSTANCE.getSubstringLengthPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<LocalDBIndexCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<LocalDBIndexCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public AttributeType getAttribute() {
            return this.pAttribute;
        }

        @Override
        public Integer getIndexEntryLimit() {
            return this.pIndexEntryLimit;
        }

        @Override
        public SortedSet<IndexType> getIndexType() {
            return this.pIndexType;
        }

        @Override
        public int getSubstringLength() {
            return this.pSubstringLength;
        }

        @Override
        public Class<? extends LocalDBIndexCfg> configurationClass() {
            return LocalDBIndexCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalDBIndexCfgClientImpl
    implements LocalDBIndexCfgClient {
        private ManagedObject<? extends LocalDBIndexCfgClient> impl;

        private LocalDBIndexCfgClientImpl(ManagedObject<? extends LocalDBIndexCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public AttributeType getAttribute() {
            return this.impl.getPropertyValue(INSTANCE.getAttributePropertyDefinition());
        }

        @Override
        public void setAttribute(AttributeType value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getAttributePropertyDefinition(), value);
        }

        @Override
        public Integer getIndexEntryLimit() {
            return this.impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
        }

        @Override
        public void setIndexEntryLimit(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition(), value);
        }

        @Override
        public SortedSet<IndexType> getIndexType() {
            return this.impl.getPropertyValues(INSTANCE.getIndexTypePropertyDefinition());
        }

        @Override
        public void setIndexType(Collection<IndexType> values) {
            this.impl.setPropertyValues(INSTANCE.getIndexTypePropertyDefinition(), values);
        }

        @Override
        public int getSubstringLength() {
            return this.impl.getPropertyValue(INSTANCE.getSubstringLengthPropertyDefinition());
        }

        @Override
        public void setSubstringLength(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getSubstringLengthPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends LocalDBIndexCfgClient, ? extends LocalDBIndexCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexType {
        APPROXIMATE("approximate"),
        EQUALITY("equality"),
        ORDERING("ordering"),
        PRESENCE("presence"),
        SUBSTRING("substring");

        private final String name;

        private IndexType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

