/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.NetworkGroupCfgClient;
import org.opends.server.admin.std.client.WorkflowCfgClient;
import org.opends.server.admin.std.server.NetworkGroupCfg;
import org.opends.server.admin.std.server.WorkflowCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkGroupCfgDefn
extends ManagedObjectDefinition<NetworkGroupCfgClient, NetworkGroupCfg> {
    private static final NetworkGroupCfgDefn INSTANCE = new NetworkGroupCfgDefn();
    private static final BooleanPropertyDefinition PD_ENABLED;
    private static final StringPropertyDefinition PD_NETWORK_GROUP_ID;
    private static final AggregationPropertyDefinition<WorkflowCfgClient, WorkflowCfg> PD_WORKFLOW;

    public static NetworkGroupCfgDefn getInstance() {
        return INSTANCE;
    }

    private NetworkGroupCfgDefn() {
        super("network-group", TopCfgDefn.getInstance());
    }

    @Override
    public NetworkGroupCfgClient createClientConfiguration(ManagedObject<? extends NetworkGroupCfgClient> impl) {
        return new NetworkGroupCfgClientImpl(impl);
    }

    @Override
    public NetworkGroupCfg createServerConfiguration(ServerManagedObject<? extends NetworkGroupCfg> impl) {
        return new NetworkGroupCfgServerImpl(impl);
    }

    @Override
    public Class<NetworkGroupCfg> getServerConfigurationClass() {
        return NetworkGroupCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PD_ENABLED;
    }

    public StringPropertyDefinition getNetworkGroupIdPropertyDefinition() {
        return PD_NETWORK_GROUP_ID;
    }

    public AggregationPropertyDefinition<WorkflowCfgClient, WorkflowCfg> getWorkflowPropertyDefinition() {
        return PD_WORKFLOW;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "enabled");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "enabled"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENABLED);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "network-group-id");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "network-group-id"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_NETWORK_GROUP_ID = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_NETWORK_GROUP_ID);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "workflow");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "workflow"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("workflow");
        PD_WORKFLOW = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_WORKFLOW);
        INSTANCE.registerConstraint(PD_WORKFLOW.getSourceConstraint());
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NetworkGroupCfgServerImpl
    implements NetworkGroupCfg {
        private ServerManagedObject<? extends NetworkGroupCfg> impl;
        private final boolean pEnabled;
        private final String pNetworkGroupId;
        private final SortedSet<String> pWorkflow;

        private NetworkGroupCfgServerImpl(ServerManagedObject<? extends NetworkGroupCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pNetworkGroupId = impl.getPropertyValue(INSTANCE.getNetworkGroupIdPropertyDefinition());
            this.pWorkflow = impl.getPropertyValues(INSTANCE.getWorkflowPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<NetworkGroupCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<NetworkGroupCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getNetworkGroupId() {
            return this.pNetworkGroupId;
        }

        @Override
        public SortedSet<String> getWorkflow() {
            return this.pWorkflow;
        }

        @Override
        public SortedSet<DN> getWorkflowDNs() {
            SortedSet<String> values = this.getWorkflow();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getWorkflowPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public Class<? extends NetworkGroupCfg> configurationClass() {
            return NetworkGroupCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NetworkGroupCfgClientImpl
    implements NetworkGroupCfgClient {
        private ManagedObject<? extends NetworkGroupCfgClient> impl;

        private NetworkGroupCfgClientImpl(ManagedObject<? extends NetworkGroupCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getNetworkGroupId() {
            return this.impl.getPropertyValue(INSTANCE.getNetworkGroupIdPropertyDefinition());
        }

        @Override
        public void setNetworkGroupId(String value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getNetworkGroupIdPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getWorkflow() {
            return this.impl.getPropertyValues(INSTANCE.getWorkflowPropertyDefinition());
        }

        @Override
        public void setWorkflow(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getWorkflowPropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends NetworkGroupCfgClient, ? extends NetworkGroupCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

