/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.ReplicationDomainCfgClient;
import org.opends.server.admin.std.server.ReplicationDomainCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReplicationDomainCfgDefn
extends ManagedObjectDefinition<ReplicationDomainCfgClient, ReplicationDomainCfg> {
    private static final ReplicationDomainCfgDefn INSTANCE = new ReplicationDomainCfgDefn();
    private static final DNPropertyDefinition PD_BASE_DN;
    private static final DurationPropertyDefinition PD_HEARTBEAT_INTERVAL;
    private static final EnumPropertyDefinition<IsolationPolicy> PD_ISOLATION_POLICY;
    private static final StringPropertyDefinition PD_REPLICATION_SERVER;
    private static final IntegerPropertyDefinition PD_SERVER_ID;
    private static final IntegerPropertyDefinition PD_WINDOW_SIZE;

    public static ReplicationDomainCfgDefn getInstance() {
        return INSTANCE;
    }

    private ReplicationDomainCfgDefn() {
        super("replication-domain", TopCfgDefn.getInstance());
    }

    @Override
    public ReplicationDomainCfgClient createClientConfiguration(ManagedObject<? extends ReplicationDomainCfgClient> impl) {
        return new ReplicationDomainCfgClientImpl(impl);
    }

    @Override
    public ReplicationDomainCfg createServerConfiguration(ServerManagedObject<? extends ReplicationDomainCfg> impl) {
        return new ReplicationDomainCfgServerImpl(impl);
    }

    @Override
    public Class<ReplicationDomainCfg> getServerConfigurationClass() {
        return ReplicationDomainCfg.class;
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return PD_BASE_DN;
    }

    public DurationPropertyDefinition getHeartbeatIntervalPropertyDefinition() {
        return PD_HEARTBEAT_INTERVAL;
    }

    public EnumPropertyDefinition<IsolationPolicy> getIsolationPolicyPropertyDefinition() {
        return PD_ISOLATION_POLICY;
    }

    public StringPropertyDefinition getReplicationServerPropertyDefinition() {
        return PD_REPLICATION_SERVER;
    }

    public IntegerPropertyDefinition getServerIdPropertyDefinition() {
        return PD_SERVER_ID;
    }

    public IntegerPropertyDefinition getWindowSizePropertyDefinition() {
        return PD_WINDOW_SIZE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = DNPropertyDefinition.createBuilder(INSTANCE, "base-dn");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "base-dn"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BASE_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BASE_DN);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "heartbeat-interval");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "heartbeat-interval"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("1000ms");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("100");
        PD_HEARTBEAT_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_HEARTBEAT_INTERVAL);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "isolation-policy");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "isolation-policy"));
        provider = new DefinedDefaultBehaviorProvider("reject-all-updates");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(IsolationPolicy.class);
        PD_ISOLATION_POLICY = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ISOLATION_POLICY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "replication-server");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-server"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^.+:[0-9]+$", "HOST:PORT");
        PD_REPLICATION_SERVER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_SERVER);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "server-id");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "server-id"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_SERVER_ID = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SERVER_ID);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "window-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "window-size"));
        provider = new DefinedDefaultBehaviorProvider("100");
        builder.setDefaultBehaviorProvider(provider);
        PD_WINDOW_SIZE = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_WINDOW_SIZE);
        INSTANCE.registerTag(Tag.valueOf("replication"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReplicationDomainCfgServerImpl
    implements ReplicationDomainCfg {
        private ServerManagedObject<? extends ReplicationDomainCfg> impl;
        private final DN pBaseDN;
        private final long pHeartbeatInterval;
        private final IsolationPolicy pIsolationPolicy;
        private final SortedSet<String> pReplicationServer;
        private final int pServerId;
        private final int pWindowSize;

        private ReplicationDomainCfgServerImpl(ServerManagedObject<? extends ReplicationDomainCfg> impl) {
            this.impl = impl;
            this.pBaseDN = impl.getPropertyValue(INSTANCE.getBaseDNPropertyDefinition());
            this.pHeartbeatInterval = impl.getPropertyValue(INSTANCE.getHeartbeatIntervalPropertyDefinition());
            this.pIsolationPolicy = impl.getPropertyValue(INSTANCE.getIsolationPolicyPropertyDefinition());
            this.pReplicationServer = impl.getPropertyValues((PropertyDefinition)INSTANCE.getReplicationServerPropertyDefinition());
            this.pServerId = impl.getPropertyValue(INSTANCE.getServerIdPropertyDefinition());
            this.pWindowSize = impl.getPropertyValue(INSTANCE.getWindowSizePropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ReplicationDomainCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ReplicationDomainCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public DN getBaseDN() {
            return this.pBaseDN;
        }

        @Override
        public long getHeartbeatInterval() {
            return this.pHeartbeatInterval;
        }

        @Override
        public IsolationPolicy getIsolationPolicy() {
            return this.pIsolationPolicy;
        }

        @Override
        public SortedSet<String> getReplicationServer() {
            return this.pReplicationServer;
        }

        @Override
        public int getServerId() {
            return this.pServerId;
        }

        @Override
        public int getWindowSize() {
            return this.pWindowSize;
        }

        @Override
        public Class<? extends ReplicationDomainCfg> configurationClass() {
            return ReplicationDomainCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReplicationDomainCfgClientImpl
    implements ReplicationDomainCfgClient {
        private ManagedObject<? extends ReplicationDomainCfgClient> impl;

        private ReplicationDomainCfgClientImpl(ManagedObject<? extends ReplicationDomainCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public DN getBaseDN() {
            return this.impl.getPropertyValue(INSTANCE.getBaseDNPropertyDefinition());
        }

        @Override
        public void setBaseDN(DN value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getBaseDNPropertyDefinition(), value);
        }

        @Override
        public long getHeartbeatInterval() {
            return this.impl.getPropertyValue(INSTANCE.getHeartbeatIntervalPropertyDefinition());
        }

        @Override
        public void setHeartbeatInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getHeartbeatIntervalPropertyDefinition(), value);
        }

        @Override
        public IsolationPolicy getIsolationPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getIsolationPolicyPropertyDefinition());
        }

        @Override
        public void setIsolationPolicy(IsolationPolicy value) {
            this.impl.setPropertyValue(INSTANCE.getIsolationPolicyPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getReplicationServer() {
            return this.impl.getPropertyValues(INSTANCE.getReplicationServerPropertyDefinition());
        }

        @Override
        public void setReplicationServer(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getReplicationServerPropertyDefinition(), values);
        }

        @Override
        public Integer getServerId() {
            return this.impl.getPropertyValue(INSTANCE.getServerIdPropertyDefinition());
        }

        @Override
        public void setServerId(int value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getServerIdPropertyDefinition(), value);
        }

        @Override
        public int getWindowSize() {
            return this.impl.getPropertyValue(INSTANCE.getWindowSizePropertyDefinition());
        }

        @Override
        public void setWindowSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getWindowSizePropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ReplicationDomainCfgClient, ? extends ReplicationDomainCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IsolationPolicy {
        ACCEPT_ALL_UPDATES("accept-all-updates"),
        REJECT_ALL_UPDATES("reject-all-updates");

        private final String name;

        private IsolationPolicy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

