/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.HashMap;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumEvalResult;

public class PatternIP {
    private IPType ipType;
    private static int IN4ADDRSZ = 4;
    private static int IPV4MAXPREFIX = 32;
    private static int IN6ADDRSZ = 16;
    private static int IPV6MAXPREFIX = 128;
    private byte[] ruleAddrBytes;
    private byte[] rulePrefixBytes;
    private BitSet wildCardBitSet;
    private static HashMap<String, String> validNetMasks = new HashMap();

    private static void initNetMask(String ... lines) {
        for (String line : lines) {
            validNetMasks.put(line, line);
        }
    }

    private PatternIP(IPType ipType, byte[] ruleAddrBytes, byte[] rulePrefixBytes, BitSet wildCardBitSet) {
        this.ipType = ipType;
        this.ruleAddrBytes = ruleAddrBytes;
        this.rulePrefixBytes = rulePrefixBytes;
        this.wildCardBitSet = wildCardBitSet;
    }

    public static PatternIP decode(String expr) throws AciException {
        byte[] addrBytes;
        String addrStr;
        byte[] prefixBytes;
        String[] s;
        IPType ipType = IPType.IPv4;
        if (expr.indexOf(58) != -1) {
            ipType = IPType.IPv6;
        }
        if (expr.indexOf(47) != -1) {
            String prefixStr = null;
            s = expr.split("[/]", -1);
            if (s.length == 2) {
                prefixStr = s[1];
            }
            int prefix = PatternIP.getPrefixValue(ipType, s.length, expr, prefixStr);
            prefixBytes = PatternIP.getPrefixBytes(prefix, ipType);
            addrStr = s[0];
        } else if (expr.indexOf(43) != -1) {
            String netMaskStr = null;
            s = expr.split("[+]", -1);
            if (s.length == 2) {
                netMaskStr = s[1];
            }
            prefixBytes = PatternIP.getNetmaskBytes(netMaskStr, s.length, expr);
            addrStr = s[0];
        } else {
            int prefix = PatternIP.getPrefixValue(ipType, 1, expr, null);
            prefixBytes = PatternIP.getPrefixBytes(prefix, ipType);
            addrStr = expr;
        }
        BitSet wildCardBitSet = new BitSet(IN6ADDRSZ);
        if (ipType == IPType.IPv4) {
            addrBytes = PatternIP.procIPv4Addr(addrStr, wildCardBitSet, expr);
        } else {
            addrBytes = PatternIP.procIPv6Addr(addrStr, expr);
            if (addrBytes.length == IN4ADDRSZ) {
                ipType = IPType.IPv4;
                prefixBytes = PatternIP.getPrefixBytes(IPV4MAXPREFIX, ipType);
            }
        }
        return new PatternIP(ipType, addrBytes, prefixBytes, wildCardBitSet);
    }

    private static int getPrefixValue(IPType ipType, int numParts, String expr, String prefixStr) throws AciException {
        int prefix = IPV4MAXPREFIX;
        int maxPrefix = IPV4MAXPREFIX;
        if (ipType == IPType.IPv6) {
            prefix = IPV6MAXPREFIX;
            maxPrefix = IPV6MAXPREFIX;
        }
        try {
            if (numParts < 1 || numParts > 2) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_PREFIX_FORMAT.get(expr);
                throw new AciException(message);
            }
            if (prefixStr != null) {
                prefix = Integer.parseInt(prefixStr);
            }
            if (prefix < 0 || prefix > maxPrefix) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_PREFIX_VALUE.get(expr);
                throw new AciException(message);
            }
        }
        catch (NumberFormatException nfex) {
            Message msg = AccessControlMessages.WARN_ACI_SYNTAX_PREFIX_NOT_NUMERIC.get(expr);
            throw new AciException(msg);
        }
        return prefix;
    }

    private static byte[] getPrefixBytes(int prefix, IPType ipType) {
        int maxSize = IN4ADDRSZ;
        if (ipType == IPType.IPv6) {
            maxSize = IN6ADDRSZ;
        }
        byte[] prefixBytes = new byte[maxSize];
        int i = 0;
        while (prefix > 8) {
            prefixBytes[i] = -1;
            prefix -= 8;
            ++i;
        }
        prefixBytes[i] = (byte)(255 << 8 - prefix);
        return prefixBytes;
    }

    private static byte[] getNetmaskBytes(String netmaskStr, int numParts, String expr) throws AciException {
        byte[] netmaskBytes = new byte[IN4ADDRSZ];
        if (!validNetMasks.containsKey(netmaskStr)) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_NETMASK.get(expr);
            throw new AciException(message);
        }
        if (numParts < 1 || numParts > 2) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_NETMASK_FORMAT.get(expr);
            throw new AciException(message);
        }
        String[] s = netmaskStr.split("\\.", -1);
        try {
            for (int i = 0; i < IN4ADDRSZ; ++i) {
                String quad = s[i].trim();
                long val = Integer.parseInt(quad);
                netmaskBytes[i] = (byte)(val & 0xFFL);
            }
        }
        catch (NumberFormatException nfex) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_IPV4_NOT_NUMERIC.get(expr);
            throw new AciException(message);
        }
        return netmaskBytes;
    }

    private static byte[] procIPv4Addr(String addrStr, BitSet wildCardBitSet, String expr) throws AciException {
        byte[] addrBytes = new byte[IN4ADDRSZ];
        String[] s = addrStr.split("\\.", -1);
        try {
            if (s.length != IN4ADDRSZ) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_IPV4_FORMAT.get(expr);
                throw new AciException(message);
            }
            for (int i = 0; i < IN4ADDRSZ; ++i) {
                String quad = s[i].trim();
                if (quad.equals("*")) {
                    wildCardBitSet.set(i);
                    continue;
                }
                long val = Integer.parseInt(quad);
                if (val < 0L || val > 255L) {
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_IPV4_VALUE.get(expr);
                    throw new AciException(message);
                }
                addrBytes[i] = (byte)(val & 0xFFL);
            }
        }
        catch (NumberFormatException nfex) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_IPV4_NOT_NUMERIC.get(expr);
            throw new AciException(message);
        }
        return addrBytes;
    }

    private static byte[] procIPv6Addr(String addrStr, String expr) throws AciException {
        byte[] addrBytes;
        if (addrStr.indexOf(42) > -1) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_IPV6_WILDCARD_INVALID.get(expr);
            throw new AciException(message);
        }
        try {
            addrBytes = InetAddress.getByName(addrStr).getAddress();
        }
        catch (UnknownHostException ex) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_IPV6_FORMAT.get(expr, ex.getMessage());
            throw new AciException(message);
        }
        return addrBytes;
    }

    public EnumEvalResult evaluate(InetAddress remoteAddr) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        IPType ipType = IPType.IPv4;
        byte[] addressBytes = remoteAddr.getAddress();
        if (remoteAddr instanceof Inet6Address) {
            ipType = IPType.IPv6;
            Inet6Address addr6 = (Inet6Address)remoteAddr;
            addressBytes = addr6.getAddress();
            if (addr6.isIPv4CompatibleAddress()) {
                ipType = IPType.IPv4;
            }
        }
        if (ipType != this.ipType) {
            return EnumEvalResult.FALSE;
        }
        if (this.matchAddress(addressBytes)) {
            matched = EnumEvalResult.TRUE;
        }
        return matched;
    }

    private boolean matchAddress(byte[] addrBytes) {
        if (this.wildCardBitSet.cardinality() == IN4ADDRSZ) {
            return true;
        }
        for (int i = 0; i < this.rulePrefixBytes.length; ++i) {
            if (this.wildCardBitSet.get(i) || (this.ruleAddrBytes[i] & this.rulePrefixBytes[i]) == (addrBytes[i] & this.rulePrefixBytes[i])) continue;
            return false;
        }
        return true;
    }

    static {
        PatternIP.initNetMask("255.255.255.255", "255.255.255.254", "255.255.255.252", "255.255.255.248", "255.255.255.240", "255.255.255.224", "255.255.255.192", "255.255.255.128", "255.255.255.0", "255.255.254.0", "255.255.252.0", "255.255.248.0", "255.255.240.0", "255.255.224.0", "255.255.192.0", "255.255.128.0", "255.255.0.0", "255.254.0.0", "255.252.0.0", "255.248.0.0", "255.240.0.0", "255.224.0.0", "255.192.0.0", "255.128.0.0", "255.0.0.0", "254.0.0.0", "252.0.0.0", "248.0.0.0", "240.0.0.0", "224.0.0.0", "192.0.0.0", "128.0.0.0", "0.0.0.0");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IPType {
        IPv4,
        IPv6;

    }
}

