/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.importLDIF.BufferManager;
import org.opends.server.backends.jeb.importLDIF.DNContext;
import org.opends.server.backends.jeb.importLDIF.ImportIDSet;
import org.opends.server.backends.jeb.importLDIF.IntegerImportIDSet;
import org.opends.server.backends.jeb.importLDIF.WorkElement;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private BlockingQueue<WorkElement> workQueue;
    private int importedCount = 0;
    private RootContainer rootContainer;
    private boolean stopRequested = false;
    private BufferManager bufferMgr;
    private Set<byte[]> insertKeySet = new HashSet<byte[]>();
    private Set<byte[]> childKeySet = new HashSet<byte[]>();
    private Set<byte[]> subtreeKeySet = new HashSet<byte[]>();
    private Set<byte[]> delKeySet = new HashSet<byte[]>();
    private DatabaseEntry keyData = new DatabaseEntry();
    private DatabaseEntry data = new DatabaseEntry();
    ImportIDSet importIDSet = new IntegerImportIDSet();
    private LinkedHashMap<DN, DNContext> importMap;

    public WorkThread(BlockingQueue<WorkElement> workQueue, int threadNumber, BufferManager bufferMgr, RootContainer rootContainer, LinkedHashMap<DN, DNContext> importMap) {
        super("Import Worker Thread " + threadNumber);
        this.workQueue = workQueue;
        this.bufferMgr = bufferMgr;
        this.rootContainer = rootContainer;
        this.importMap = importMap;
    }

    int getImportedCount() {
        return this.importedCount;
    }

    void stopProcessing() {
        this.stopRequested = true;
    }

    @Override
    public void run() {
        try {
            do {
                try {
                    WorkElement element = this.workQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    if (element == null) continue;
                    this.process(element);
                }
                catch (InterruptedException e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            } while (!this.stopRequested);
            this.closeIndexCursors();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new RuntimeException(e);
        }
    }

    private void closeIndexCursors() throws DatabaseException {
        for (DNContext ic : this.importMap.values()) {
            ic.getEntryContainer().closeIndexCursors();
        }
    }

    public void process(WorkElement element) throws DatabaseException, DirectoryException, JebException {
        EntryID entryID = this.processDN2ID(element);
        if (entryID == null) {
            return;
        }
        if (!this.processID2Entry(element, entryID)) {
            return;
        }
        this.procesID2SCEntry(element, entryID);
        this.processIndexesEntry(element, entryID);
    }

    private void processIndexesEntryDelete(WorkElement element, Entry existingEntry, EntryID entryID) throws DatabaseException {
        DNContext context = element.getContext();
        Map<AttributeType, AttributeIndex> attrIndexMap = context.getAttrIndexMap();
        for (Map.Entry<AttributeType, AttributeIndex> mapEntry : attrIndexMap.entrySet()) {
            AttributeType attrType = mapEntry.getKey();
            if (!existingEntry.hasAttribute(attrType)) continue;
            AttributeIndex attributeIndex = mapEntry.getValue();
            Index index = attributeIndex.getEqualityIndex();
            if (index != null) {
                this.delete(index, existingEntry, entryID);
            }
            if ((index = attributeIndex.getPresenceIndex()) != null) {
                this.delete(index, existingEntry, entryID);
            }
            if ((index = attributeIndex.getSubstringIndex()) != null) {
                this.delete(index, existingEntry, entryID);
            }
            if ((index = attributeIndex.getOrderingIndex()) != null) {
                this.delete(index, existingEntry, entryID);
            }
            if ((index = attributeIndex.getApproximateIndex()) == null) continue;
            this.delete(index, existingEntry, entryID);
        }
    }

    private void processIndexesEntry(WorkElement element, EntryID entryID) throws DatabaseException {
        Entry existingEntry;
        Entry entry = element.getEntry();
        DNContext context = element.getContext();
        LDIFImportConfig ldifImportConfig = context.getLDIFImportConfig();
        if (ldifImportConfig.appendToExistingData() && ldifImportConfig.replaceExistingEntries() && (existingEntry = element.getExistingEntry()) != null) {
            this.processIndexesEntryDelete(element, existingEntry, entryID);
        }
        Map<AttributeType, AttributeIndex> attrIndexMap = context.getAttrIndexMap();
        for (Map.Entry<AttributeType, AttributeIndex> mapEntry : attrIndexMap.entrySet()) {
            AttributeType attrType = mapEntry.getKey();
            if (!entry.hasAttribute(attrType)) continue;
            AttributeIndex attributeIndex = mapEntry.getValue();
            Index index = attributeIndex.getEqualityIndex();
            if (index != null) {
                this.insert(index, entry, entryID);
            }
            if ((index = attributeIndex.getPresenceIndex()) != null) {
                this.insert(index, entry, entryID);
            }
            if ((index = attributeIndex.getSubstringIndex()) != null) {
                this.bufferMgr.insert(index, entry, entryID, this.insertKeySet);
            }
            if ((index = attributeIndex.getOrderingIndex()) != null) {
                this.insert(index, entry, entryID);
            }
            if ((index = attributeIndex.getApproximateIndex()) == null) continue;
            this.insert(index, entry, entryID);
        }
    }

    private void procesID2SCEntry(WorkElement element, EntryID entryID) throws DatabaseException {
        Entry entry = element.getEntry();
        DNContext context = element.getContext();
        LDIFImportConfig ldifImportConfig = context.getLDIFImportConfig();
        if (ldifImportConfig.appendToExistingData() && ldifImportConfig.replaceExistingEntries()) {
            return;
        }
        Index id2children = context.getEntryContainer().getID2Children();
        Index id2subtree = context.getEntryContainer().getID2Subtree();
        this.bufferMgr.insert(id2children, id2subtree, entry, entryID, this.childKeySet, this.subtreeKeySet);
    }

    private boolean insert(Index index, Entry entry, EntryID entryID) throws DatabaseException {
        this.insertKeySet.clear();
        index.indexer.indexEntry(entry, this.insertKeySet);
        this.importIDSet.setEntryID(entryID);
        return index.insert(this.importIDSet, this.insertKeySet, this.keyData, this.data);
    }

    private void delete(Index index, Entry entry, EntryID entryID) throws DatabaseException {
        this.delKeySet.clear();
        index.indexer.indexEntry(entry, this.delKeySet);
        index.delete(null, this.delKeySet, entryID);
    }

    private boolean processID2Entry(WorkElement element, EntryID entryID) throws DatabaseException, DirectoryException {
        Entry entry = element.getEntry();
        DNContext context = element.getContext();
        ID2Entry id2entry = context.getEntryContainer().getID2Entry();
        DN2URI dn2uri = context.getEntryContainer().getDN2URI();
        boolean ret = id2entry.put(null, entryID, entry);
        if (ret) {
            ++this.importedCount;
            LDIFImportConfig ldifImportConfig = context.getLDIFImportConfig();
            if (ldifImportConfig.appendToExistingData() && ldifImportConfig.replaceExistingEntries()) {
                Entry existingEntry = element.getExistingEntry();
                if (existingEntry != null) {
                    dn2uri.replaceEntry(null, existingEntry, entry);
                }
            } else {
                ret = dn2uri.addEntry(null, entry);
            }
        }
        return ret;
    }

    private boolean processParent(WorkElement element) throws DatabaseException {
        ArrayList<Object> IDs;
        Entry entry = element.getEntry();
        DNContext context = element.getContext();
        LDIFImportConfig ldifImportConfig = context.getLDIFImportConfig();
        if (ldifImportConfig.appendToExistingData() && ldifImportConfig.replaceExistingEntries()) {
            return true;
        }
        EntryID parentID = null;
        DN entryDN = entry.getDN();
        DN parentDN = context.getEntryContainer().getParentWithinBase(entryDN);
        DN2ID dn2id = context.getEntryContainer().getDN2ID();
        if (parentDN != null && (parentID = context.getParentID(parentDN, dn2id)) == null) {
            dn2id.remove(null, entryDN);
            Message msg = JebMessages.ERR_JEB_IMPORT_PARENT_NOT_FOUND.get(parentDN.toString());
            context.getLDIFReader().rejectLastEntry(msg);
            return false;
        }
        EntryID entryID = this.rootContainer.getNextEntryID();
        if (parentDN != null && context.getParentDN() != null && parentDN.equals(context.getParentDN())) {
            IDs = new ArrayList<EntryID>(context.getIDs());
            IDs.set(0, entryID);
        } else {
            IDs = new ArrayList<EntryID>(entryDN.getNumComponents());
            IDs.add(entryID);
            if (parentID != null) {
                IDs.add(parentID);
                EntryContainer ec = context.getEntryContainer();
                DN dn = ec.getParentWithinBase(parentDN);
                while (dn != null) {
                    EntryID nodeID = this.getAncestorID(dn2id, dn);
                    if (nodeID == null) {
                        return false;
                    }
                    IDs.add(nodeID);
                    dn = ec.getParentWithinBase(dn);
                }
            }
        }
        context.setParentDN(parentDN);
        context.setIDs(IDs);
        entry.setAttachment(IDs);
        return true;
    }

    private EntryID getAncestorID(DN2ID dn2id, DN dn) throws DatabaseException {
        int i = 0;
        EntryID nodeID = dn2id.get(null, dn, LockMode.DEFAULT);
        if (nodeID == null) {
            while ((nodeID = dn2id.get(null, dn, LockMode.DEFAULT)) == null) {
                try {
                    Thread.sleep(50L);
                    if (i == 3) {
                        return null;
                    }
                    ++i;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return nodeID;
    }

    private EntryID processDN2ID(WorkElement element) throws DatabaseException, DirectoryException {
        Entry entry = element.getEntry();
        DNContext context = element.getContext();
        DN2ID dn2id = context.getEntryContainer().getDN2ID();
        LDIFImportConfig ldifImportConfig = context.getLDIFImportConfig();
        DN entryDN = entry.getDN();
        EntryID entryID = dn2id.get(null, entryDN, LockMode.DEFAULT);
        if (entryID != null) {
            if (ldifImportConfig.appendToExistingData() && ldifImportConfig.replaceExistingEntries()) {
                ID2Entry id2entry = context.getEntryContainer().getID2Entry();
                Entry existingEntry = id2entry.get(null, entryID, LockMode.DEFAULT);
                element.setExistingEntry(existingEntry);
            } else {
                Message msg = JebMessages.WARN_JEB_IMPORT_ENTRY_EXISTS.get();
                context.getLDIFReader().rejectLastEntry(msg);
                entryID = null;
            }
        } else {
            if (!this.processParent(element)) {
                return null;
            }
            if (ldifImportConfig.appendToExistingData() && ldifImportConfig.replaceExistingEntries()) {
                entryID = this.rootContainer.getNextEntryID();
            } else {
                ArrayList IDs = (ArrayList)entry.getAttachment();
                entryID = (EntryID)IDs.get(0);
            }
            dn2id.insert(null, entryDN, entryID);
        }
        context.removePending(entryDN);
        return entryID;
    }
}

