/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Arrays;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.RC4PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RC4PasswordStorageScheme
extends PasswordStorageScheme<RC4PasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private CryptoManager cryptoManager;

    @Override
    public void initializePasswordStorageScheme(RC4PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
        this.cryptoManager = DirectoryServer.getCryptoManager();
    }

    @Override
    public String getStorageSchemeName() {
        return "RC4";
    }

    @Override
    public ByteString encodePassword(ByteString plaintext) throws DirectoryException {
        try {
            byte[] encodedBytes = this.cryptoManager.encrypt("RC4/NONE/NoPadding", 128, plaintext.value());
            return ByteStringFactory.create(Base64.encode(encodedBytes));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message m = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCRYPT.get("RC4", StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, e);
        }
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteString plaintext) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("RC4");
        buffer.append('}');
        try {
            byte[] encodedBytes = this.cryptoManager.encrypt("RC4/NONE/NoPadding", 128, plaintext.value());
            buffer.append(Base64.encode(encodedBytes));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message m = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCRYPT.get("RC4", StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, e);
        }
        return ByteStringFactory.create(buffer.toString());
    }

    @Override
    public boolean passwordMatches(ByteString plaintextPassword, ByteString storedPassword) {
        try {
            byte[] decryptedPassword = this.cryptoManager.decrypt(Base64.decode(storedPassword.stringValue()));
            return Arrays.equals(plaintextPassword.value(), decryptedPassword);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public ByteString getPlaintextValue(ByteString storedPassword) throws DirectoryException {
        try {
            byte[] decryptedPassword = this.cryptoManager.decrypt(Base64.decode(storedPassword.stringValue()));
            return ByteStringFactory.create(decryptedPassword);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message m = ExtensionMessages.ERR_PWSCHEME_CANNOT_DECRYPT.get("RC4", StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, e);
        }
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    @Override
    public ByteString encodeAuthPassword(ByteString plaintext) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean authPasswordMatches(ByteString plaintextPassword, String authInfo, String authValue) {
        return false;
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return true;
    }
}

