/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.PasswordGeneratorCfg;
import org.opends.server.admin.std.server.RandomPasswordGeneratorCfg;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NamedCharacterSet;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomPasswordGenerator
extends PasswordGenerator<RandomPasswordGeneratorCfg>
implements ConfigurationChangeListener<RandomPasswordGeneratorCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private RandomPasswordGeneratorCfg currentConfig;
    private SortedSet<String> encodedCharacterSets;
    private DN configEntryDN;
    private int totalLength;
    private int[] characterCounts;
    private NamedCharacterSet[] characterSets;
    private Object generatorLock;
    private String formatString;

    @Override
    public void initializePasswordGenerator(RandomPasswordGeneratorCfg configuration) throws ConfigException, InitializationException {
        this.configEntryDN = configuration.dn();
        this.generatorLock = new Object();
        HashMap<String, NamedCharacterSet> charsets = new HashMap<String, NamedCharacterSet>();
        try {
            this.encodedCharacterSets = configuration.getPasswordCharacterSet();
            if (this.encodedCharacterSets.size() == 0) {
                Message message = ExtensionMessages.ERR_RANDOMPWGEN_NO_CHARSETS.get(String.valueOf(this.configEntryDN));
                throw new ConfigException(message);
            }
            for (NamedCharacterSet s : NamedCharacterSet.decodeCharacterSets(this.encodedCharacterSets)) {
                if (charsets.containsKey(s.getName())) {
                    Message message = ExtensionMessages.ERR_RANDOMPWGEN_CHARSET_NAME_CONFLICT.get(String.valueOf(this.configEntryDN), s.getName());
                    throw new ConfigException(message);
                }
                charsets.put(s.getName(), s);
            }
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_RANDOMPWGEN_CANNOT_DETERMINE_CHARSETS.get(StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        try {
            this.formatString = configuration.getPasswordFormat();
            StringTokenizer tokenizer = new StringTokenizer(this.formatString, ", ");
            ArrayList<NamedCharacterSet> setList = new ArrayList<NamedCharacterSet>();
            ArrayList<Integer> countList = new ArrayList<Integer>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                try {
                    int colonPos = token.indexOf(58);
                    String name = token.substring(0, colonPos);
                    int count = Integer.parseInt(token.substring(colonPos + 1));
                    NamedCharacterSet charset = (NamedCharacterSet)charsets.get(name);
                    if (charset == null) {
                        Message message = ExtensionMessages.ERR_RANDOMPWGEN_UNKNOWN_CHARSET.get(String.valueOf(this.formatString), String.valueOf(name));
                        throw new ConfigException(message);
                    }
                    setList.add(charset);
                    countList.add(count);
                }
                catch (ConfigException ce) {
                    throw ce;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ExtensionMessages.ERR_RANDOMPWGEN_INVALID_PWFORMAT.get(String.valueOf(this.formatString));
                    throw new ConfigException(message, (Throwable)e);
                }
            }
            this.characterSets = new NamedCharacterSet[setList.size()];
            this.characterCounts = new int[this.characterSets.length];
            this.totalLength = 0;
            for (int i = 0; i < this.characterSets.length; ++i) {
                this.characterSets[i] = (NamedCharacterSet)setList.get(i);
                this.characterCounts[i] = (Integer)countList.get(i);
                this.totalLength += this.characterCounts[i];
            }
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_RANDOMPWGEN_CANNOT_DETERMINE_PWFORMAT.get(StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        configuration.addRandomChangeListener(this);
        this.currentConfig = configuration;
    }

    @Override
    public void finalizePasswordGenerator() {
        this.currentConfig.removeRandomChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString generatePassword(Entry userEntry) throws DirectoryException {
        StringBuilder buffer = new StringBuilder(this.totalLength);
        Object object = this.generatorLock;
        synchronized (object) {
            for (int i = 0; i < this.characterSets.length; ++i) {
                this.characterSets[i].getRandomCharacters(buffer, this.characterCounts[i]);
            }
        }
        return ByteStringFactory.create(buffer.toString());
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordGeneratorCfg configuration, List<Message> unacceptableReasons) {
        RandomPasswordGeneratorCfg config = (RandomPasswordGeneratorCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isConfigurationChangeAcceptable(RandomPasswordGeneratorCfg configuration, List<Message> unacceptableReasons) {
        DN cfgEntryDN = configuration.dn();
        HashMap<String, NamedCharacterSet> charsets = new HashMap<String, NamedCharacterSet>();
        try {
            SortedSet<String> currentPasSet = configuration.getPasswordCharacterSet();
            if (currentPasSet.size() == 0) {
                Message message = ExtensionMessages.ERR_RANDOMPWGEN_NO_CHARSETS.get(String.valueOf(cfgEntryDN));
                throw new ConfigException(message);
            }
            for (NamedCharacterSet s : NamedCharacterSet.decodeCharacterSets(currentPasSet)) {
                if (charsets.containsKey(s.getName())) {
                    Message message = ExtensionMessages.ERR_RANDOMPWGEN_CHARSET_NAME_CONFLICT.get(String.valueOf(cfgEntryDN), s.getName());
                    unacceptableReasons.add(message);
                    return false;
                }
                charsets.put(s.getName(), s);
            }
        }
        catch (ConfigException ce) {
            unacceptableReasons.add(ce.getMessageObject());
            return false;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_RANDOMPWGEN_CANNOT_DETERMINE_CHARSETS.get(StaticUtils.getExceptionMessage(e));
            unacceptableReasons.add(message);
            return false;
        }
        try {
            String formatString = configuration.getPasswordFormat();
            StringTokenizer tokenizer = new StringTokenizer(formatString, ", ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                try {
                    int colonPos = token.indexOf(58);
                    String name = token.substring(0, colonPos);
                    int count = Integer.parseInt(token.substring(colonPos + 1));
                    NamedCharacterSet charset = (NamedCharacterSet)charsets.get(name);
                    if (charset != null) continue;
                    Message message = ExtensionMessages.ERR_RANDOMPWGEN_UNKNOWN_CHARSET.get(String.valueOf(formatString), String.valueOf(name));
                    unacceptableReasons.add(message);
                    return false;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ExtensionMessages.ERR_RANDOMPWGEN_INVALID_PWFORMAT.get(String.valueOf(formatString));
                    unacceptableReasons.add(message);
                    return false;
                    return true;
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_RANDOMPWGEN_CANNOT_DETERMINE_PWFORMAT.get(StaticUtils.getExceptionMessage(e));
            unacceptableReasons.add(message);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(RandomPasswordGeneratorCfg configuration) {
        String newFormatString;
        ArrayList<Integer> newCountList;
        ArrayList<NamedCharacterSet> newSetList;
        SortedSet<String> newEncodedCharacterSets;
        ArrayList<Message> messages;
        boolean adminActionRequired;
        ResultCode resultCode;
        block24: {
            HashMap<String, NamedCharacterSet> charsets;
            block23: {
                resultCode = ResultCode.SUCCESS;
                adminActionRequired = false;
                messages = new ArrayList<Message>();
                newEncodedCharacterSets = null;
                charsets = new HashMap<String, NamedCharacterSet>();
                try {
                    newEncodedCharacterSets = configuration.getPasswordCharacterSet();
                    if (newEncodedCharacterSets.size() == 0) {
                        messages.add(ExtensionMessages.ERR_RANDOMPWGEN_NO_CHARSETS.get(String.valueOf(this.configEntryDN)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                        }
                    } else {
                        for (NamedCharacterSet s : NamedCharacterSet.decodeCharacterSets(newEncodedCharacterSets)) {
                            if (charsets.containsKey(s.getName())) {
                                messages.add(ExtensionMessages.ERR_RANDOMPWGEN_CHARSET_NAME_CONFLICT.get(String.valueOf(this.configEntryDN), s.getName()));
                                if (resultCode != ResultCode.SUCCESS) continue;
                                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                continue;
                            }
                            charsets.put(s.getName(), s);
                        }
                    }
                }
                catch (ConfigException ce) {
                    messages.add(ce.getMessageObject());
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    messages.add(ExtensionMessages.ERR_RANDOMPWGEN_CANNOT_DETERMINE_CHARSETS.get(StaticUtils.getExceptionMessage(e)));
                    if (resultCode != ResultCode.SUCCESS) break block23;
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            newSetList = new ArrayList<NamedCharacterSet>();
            newCountList = new ArrayList<Integer>();
            newFormatString = null;
            try {
                newFormatString = configuration.getPasswordFormat();
                StringTokenizer tokenizer = new StringTokenizer(newFormatString, ", ");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    try {
                        int colonPos = token.indexOf(58);
                        String name = token.substring(0, colonPos);
                        int count = Integer.parseInt(token.substring(colonPos + 1));
                        NamedCharacterSet charset = (NamedCharacterSet)charsets.get(name);
                        if (charset == null) {
                            messages.add(ExtensionMessages.ERR_RANDOMPWGEN_UNKNOWN_CHARSET.get(String.valueOf(newFormatString), String.valueOf(name)));
                            if (resultCode != ResultCode.SUCCESS) continue;
                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                            continue;
                        }
                        newSetList.add(charset);
                        newCountList.add(count);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        messages.add(ExtensionMessages.ERR_RANDOMPWGEN_INVALID_PWFORMAT.get(String.valueOf(newFormatString)));
                        if (resultCode != ResultCode.SUCCESS) continue;
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(ExtensionMessages.ERR_RANDOMPWGEN_CANNOT_DETERMINE_PWFORMAT.get(StaticUtils.getExceptionMessage(e)));
                if (resultCode != ResultCode.SUCCESS) break block24;
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            Object object = this.generatorLock;
            synchronized (object) {
                this.encodedCharacterSets = newEncodedCharacterSets;
                this.formatString = newFormatString;
                this.characterSets = new NamedCharacterSet[newSetList.size()];
                this.characterCounts = new int[this.characterSets.length];
                this.totalLength = 0;
                for (int i = 0; i < this.characterCounts.length; ++i) {
                    this.characterSets[i] = (NamedCharacterSet)newSetList.get(i);
                    this.characterCounts[i] = (Integer)newCountList.get(i);
                    this.totalLength += this.characterCounts[i];
                }
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

