/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.MonitorProvider;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.BooleanSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.ObjectClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendMonitor
extends MonitorProvider<MonitorProviderCfg> {
    private AttributeType backendIDType;
    private AttributeType baseDNType;
    private AttributeType entryCountType;
    private AttributeType baseDNEntryCountType;
    private AttributeType isPrivateType;
    private AttributeType writabilityModeType;
    private Backend backend;
    private String monitorName;
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public BackendMonitor(Backend backend) {
        super(backend.getBackendID() + " Backend");
        this.backend = backend;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) {
        this.monitorName = this.backend.getBackendID() + " Backend";
        this.backendIDType = DirectoryConfig.getAttributeType("ds-backend-id", true);
        this.baseDNType = DirectoryConfig.getAttributeType("ds-backend-base-dn", true);
        this.entryCountType = DirectoryConfig.getAttributeType("ds-backend-entry-count", true);
        this.baseDNEntryCountType = DirectoryConfig.getAttributeType("ds-base-dn-entry-count", true);
        this.isPrivateType = DirectoryConfig.getAttributeType("ds-backend-is-private", true);
        this.writabilityModeType = DirectoryConfig.getAttributeType("ds-backend-writability-mode", true);
    }

    @Override
    public String getMonitorInstanceName() {
        return this.monitorName;
    }

    @Override
    public ObjectClass getMonitorObjectClass() {
        return DirectoryConfig.getObjectClass("ds-backend-monitor-entry", true);
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    @Override
    public List<Attribute> getMonitorData() {
        DN[] baseDNs;
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>();
        values.add(new AttributeValue(this.backendIDType, ByteStringFactory.create(this.backend.getBackendID())));
        attrs.add(new Attribute(this.backendIDType, "ds-backend-id", values));
        values = new LinkedHashSet();
        for (DN dn : baseDNs = this.backend.getBaseDNs()) {
            values.add(new AttributeValue(this.baseDNType, ByteStringFactory.create(dn.toString())));
        }
        attrs.add(new Attribute(this.baseDNType, "ds-backend-base-dn", values));
        values = new LinkedHashSet();
        values.add(BooleanSyntax.createBooleanValue(this.backend.isPrivateBackend()));
        attrs.add(new Attribute(this.isPrivateType, "ds-backend-is-private", values));
        values = new LinkedHashSet();
        long backendCount = this.backend.getEntryCount();
        values.add(new AttributeValue(this.entryCountType, ByteStringFactory.create(String.valueOf(backendCount))));
        attrs.add(new Attribute(this.entryCountType, "ds-backend-entry-count", values));
        values = new LinkedHashSet();
        if (baseDNs.length != 1) {
            for (DN dn : baseDNs) {
                long entryCount;
                block6: {
                    entryCount = -1L;
                    try {
                        entryCount = this.backend.numSubordinates(dn, true) + 1L;
                    }
                    catch (Exception ex) {
                        if (!DebugLogger.debugEnabled()) break block6;
                        TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                    }
                }
                String s = entryCount + " " + dn.toString();
                values.add(new AttributeValue(this.baseDNEntryCountType, ByteStringFactory.create(s)));
            }
        } else {
            String s = backendCount + " " + baseDNs[0].toString();
            values.add(new AttributeValue(this.baseDNEntryCountType, ByteStringFactory.create(s)));
        }
        attrs.add(new Attribute(this.baseDNEntryCountType, "ds-base-dn-entry-count", values));
        values = new LinkedHashSet();
        values.add(new AttributeValue(this.writabilityModeType, ByteStringFactory.create(String.valueOf((Object)this.backend.getWritabilityMode()))));
        attrs.add(new Attribute(this.writabilityModeType, "ds-backend-writability-mode", values));
        return attrs;
    }
}

