/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.util.ArrayList;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.core.BindOperationBasis;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.jmx.Credential;
import org.opends.server.protocols.jmx.JmxClientConnection;
import org.opends.server.protocols.jmx.JmxConnectionHandler;
import org.opends.server.protocols.jmx.OpendsJmxPrincipal;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;

public class RmiAuthenticator
implements JMXAuthenticator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean needClientCertificate = false;
    private boolean finalizedPhase = false;
    private JmxConnectionHandler jmxConnectionHandler;

    public RmiAuthenticator(JmxConnectionHandler jmxConnectionHandler) {
        this.jmxConnectionHandler = jmxConnectionHandler;
    }

    public synchronized void setFinalizedPhase(boolean finalizedPhase) {
        this.finalizedPhase = finalizedPhase;
    }

    public Subject authenticate(Object credentials) {
        JmxClientConnection jmxClientConnection;
        if (this.finalizedPhase) {
            SecurityException se = new SecurityException();
            throw se;
        }
        if (credentials == null) {
            SecurityException se = new SecurityException();
            throw se;
        }
        Object[] c = (Object[])credentials;
        String authcID = (String)c[0];
        String password = (String)c[1];
        if (authcID == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("User name is Null");
            }
            SecurityException se = new SecurityException();
            throw se;
        }
        if (password == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("User password is Null ");
            }
            SecurityException se = new SecurityException();
            throw se;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("UserName = %s", authcID);
        }
        try {
            jmxClientConnection = this.bind(authcID, password);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            SecurityException se = new SecurityException(e.getMessage());
            se.initCause(e);
            throw se;
        }
        PluginConfigManager pluginManager = DirectoryServer.getPluginConfigManager();
        PluginResult.PostConnect pluginResult = pluginManager.invokePostConnectPlugins(jmxClientConnection);
        if (!pluginResult.continueProcessing()) {
            jmxClientConnection.disconnect(pluginResult.getDisconnectReason(), pluginResult.sendDisconnectNotification(), pluginResult.getErrorMessage());
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("Disconnect result from post connect plugins: %s: %s ", new Object[]{pluginResult.getDisconnectReason(), pluginResult.getErrorMessage()});
            }
            SecurityException se = new SecurityException();
            throw se;
        }
        Subject s = new Subject();
        s.getPrincipals().add(new OpendsJmxPrincipal(authcID));
        s.getPrivateCredentials().add(new Credential(jmxClientConnection));
        return s;
    }

    private JmxClientConnection bind(String authcID, String password) {
        ArrayList<Control> requestControls = new ArrayList<Control>();
        try {
            DN bindDN = DN.decode(authcID);
        }
        catch (Exception e) {
            LDAPException ldapEx = new LDAPException(49, CoreMessages.INFO_RESULT_INVALID_CREDENTIALS.get());
            SecurityException se = new SecurityException();
            se.initCause(ldapEx);
            throw se;
        }
        ASN1OctetString bindPW = password == null ? null : new ASN1OctetString(password);
        AuthenticationInfo authInfo = new AuthenticationInfo();
        JmxClientConnection jmxClientConnection = new JmxClientConnection(this.jmxConnectionHandler, authInfo);
        BindOperationBasis bindOp = new BindOperationBasis((ClientConnection)jmxClientConnection, jmxClientConnection.nextOperationID(), jmxClientConnection.nextMessageID(), requestControls, this.jmxConnectionHandler.getRMIConnector().getProtocolVersion(), new ASN1OctetString(authcID), (ByteString)bindPW);
        bindOp.run();
        if (bindOp.getResultCode() == ResultCode.SUCCESS) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("User is authenticated");
            }
            authInfo = bindOp.getAuthenticationInfo();
            jmxClientConnection.setAuthenticationInfo(authInfo);
            if (!jmxClientConnection.hasPrivilege(Privilege.JMX_READ, null)) {
                Message message = ProtocolMessages.ERR_JMX_INSUFFICIENT_PRIVILEGES.get();
                jmxClientConnection.disconnect(DisconnectReason.CONNECTION_REJECTED, false, message);
                throw new SecurityException(message.toString());
            }
            return jmxClientConnection;
        }
        LDAPException ldapEx = new LDAPException(49, CoreMessages.INFO_RESULT_INVALID_CREDENTIALS.get());
        SecurityException se = new SecurityException("return code: " + (Object)((Object)bindOp.getResultCode()));
        se.initCause(ldapEx);
        throw se;
    }
}

