/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyResponseProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN matchedDN;
    private int resultCode;
    private List<String> referralURLs;
    private Message errorMessage;

    public ModifyResponseProtocolOp(int resultCode) {
        this.resultCode = resultCode;
        this.errorMessage = null;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public ModifyResponseProtocolOp(int resultCode, Message errorMessage) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public ModifyResponseProtocolOp(int resultCode, Message errorMessage, DN matchedDN, List<String> referralURLs) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public Message getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(Message errorMessage) {
        this.errorMessage = errorMessage;
    }

    public DN getMatchedDN() {
        return this.matchedDN;
    }

    public void setMatchedDN(DN matchedDN) {
        this.matchedDN = matchedDN;
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    public void setReferralURLs(List<String> referralURLs) {
        this.referralURLs = referralURLs;
    }

    @Override
    public byte getType() {
        return 103;
    }

    @Override
    public String getProtocolOpName() {
        return "Modify Response";
    }

    @Override
    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        elements.add(new ASN1Enumerated(this.resultCode));
        if (this.matchedDN == null) {
            elements.add(new ASN1OctetString());
        } else {
            elements.add(new ASN1OctetString(this.matchedDN.toString()));
        }
        elements.add(new ASN1OctetString(this.errorMessage));
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            ArrayList<ASN1Element> referralElements = new ArrayList<ASN1Element>(this.referralURLs.size());
            for (String s : this.referralURLs) {
                referralElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-93, referralElements));
        }
        return new ASN1Sequence(103, elements);
    }

    public static ModifyResponseProtocolOp decodeModifyResponse(ASN1Element element) throws LDAPException {
        ArrayList<String> referralURLs;
        Message errorMessage;
        DN matchedDN;
        int resultCode;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        int numElements = elements.size();
        if (numElements < 3 || numElements > 4) {
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_INVALID_ELEMENT_COUNT.get(numElements);
            throw new LDAPException(2, message);
        }
        try {
            resultCode = elements.get(0).decodeAsInteger().intValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_RESULT_CODE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            String dnString = elements.get(1).decodeAsOctetString().stringValue();
            matchedDN = dnString.length() == 0 ? null : DN.decode(dnString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_MATCHED_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            errorMessage = Message.raw(elements.get(2).decodeAsOctetString().stringValue(), new Object[0]);
            if (errorMessage.length() == 0) {
                errorMessage = null;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_ERROR_MESSAGE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        if (numElements == 3) {
            referralURLs = null;
        } else {
            try {
                ArrayList<ASN1Element> referralElements = elements.get(3).decodeAsSequence().elements();
                referralURLs = new ArrayList<String>(referralElements.size());
                for (ASN1Element e : referralElements) {
                    referralURLs.add(e.decodeAsOctetString().stringValue());
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_RESULT_DECODE_REFERRALS.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
        }
        return new ModifyResponseProtocolOp(resultCode, errorMessage, matchedDN, referralURLs);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ModifyResponse(resultCode=");
        buffer.append(this.resultCode);
        if (this.errorMessage != null && this.errorMessage.length() > 0) {
            buffer.append(", errorMessage=");
            buffer.append(this.errorMessage);
        }
        if (this.matchedDN != null) {
            buffer.append(", matchedDN=");
            buffer.append(this.matchedDN.toString());
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            buffer.append(", referralURLs={");
            Iterator<String> iterator = this.referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            buffer.append("}");
        }
        buffer.append(")");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Modify Response");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Result Code:  ");
        buffer.append(this.resultCode);
        buffer.append(ServerConstants.EOL);
        if (this.errorMessage != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Error Message:  ");
            buffer.append(this.errorMessage);
            buffer.append(ServerConstants.EOL);
        }
        if (this.matchedDN != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Matched DN:  ");
            this.matchedDN.toString(buffer);
            buffer.append(ServerConstants.EOL);
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Referral URLs:  ");
            buffer.append(ServerConstants.EOL);
            for (String s : this.referralURLs) {
                buffer.append((CharSequence)indentBuf);
                buffer.append("  ");
                buffer.append(s);
                buffer.append(ServerConstants.EOL);
            }
        }
    }
}

