/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Null;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;

public class UnbindRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public byte getType() {
        return 66;
    }

    public String getProtocolOpName() {
        return "Unbind Request";
    }

    public ASN1Element encode() {
        return new ASN1Null(66);
    }

    public static UnbindRequestProtocolOp decodeUnbindRequest(ASN1Element element) throws LDAPException {
        try {
            element.decodeAsNull();
            return new UnbindRequestProtocolOp();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_UNBIND_DECODE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
    }

    public void toString(StringBuilder buffer) {
        buffer.append("UnbindRequest()");
    }

    public void toString(StringBuilder buffer, int indent) {
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        buffer.append("Unbind Request");
        buffer.append(ServerConstants.EOL);
    }
}

