/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.ReplicationMessage;

public abstract class StartMessage
extends ReplicationMessage {
    private short protocolVersion;
    private long generationId;
    protected int headerLength;

    public StartMessage(short protocolVersion, long generationId) {
        this.protocolVersion = protocolVersion;
        this.generationId = generationId;
    }

    public StartMessage(byte type, byte[] encodedMsg) throws DataFormatException {
        this.headerLength = this.decodeHeader(type, encodedMsg);
    }

    public byte[] encodeHeader(byte type, int additionalLength) throws UnsupportedEncodingException {
        byte[] versionByte = Short.toString(this.protocolVersion).getBytes("UTF-8");
        byte[] byteGenerationID = String.valueOf(this.generationId).getBytes("UTF-8");
        int length = 1 + versionByte.length + 1 + byteGenerationID.length + 1 + additionalLength;
        byte[] encodedMsg = new byte[length];
        encodedMsg[0] = type;
        int pos = 1;
        pos = this.addByteArray(versionByte, encodedMsg, pos);
        this.headerLength = this.addByteArray(byteGenerationID, encodedMsg, pos);
        return encodedMsg;
    }

    public int decodeHeader(byte type, byte[] encodedMsg) throws DataFormatException {
        if (encodedMsg[0] != type) {
            throw new DataFormatException("byte[] is not a valid msg");
        }
        try {
            int pos = 1;
            int length = this.getNextLength(encodedMsg, pos);
            this.protocolVersion = Short.valueOf(new String(encodedMsg, pos, length, "UTF-8"));
            pos += length + 1;
            length = this.getNextLength(encodedMsg, pos);
            this.generationId = Long.valueOf(new String(encodedMsg, pos, length, "UTF-8"));
            return pos += length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public short getVersion() {
        return this.protocolVersion;
    }

    public long getGenerationId() {
        return this.generationId;
    }
}

